/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IArchiveAction;
import jp.sourceforge.shovel.action.impl.ArchiveActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class ArchiveActionImpl
implements IArchiveAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;

    @Perform(CSRF=false)
    public String perform() throws Exception {
        FormatType formatType = this.actionForm_.getFormatType();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        int page = this.actionForm_.getPage();
        int limit = this.actionForm_.getCount();
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)this.getSession().getAttribute("listRefine");
            if (listRefine == null || !listRefine.getViewType().isArchive()) {
                listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
                this.getSession().setAttribute("listRefine", (Object)listRefine);
            } else if (this.actionForm_.getMethodType().isPage()) {
                listRefine.setPage(this.actionForm_.getPage());
            }
            listRefine.setViewType(ViewType.ARCHIVE);
            page = listRefine.getPage();
            limit = 0;
        }
        IStatus[] tmp = shovelService.getStatuses(user.getForeignKey(), false, page, limit, 0, 1);
        IStatus[] statuses = shovelService.prepareForView(tmp, limit, true);
        boolean nextPage = false;
        if (statuses != null && statuses.length > 0) {
            nextPage = tmp.length > statuses.length;
        }
        this.request_.setAttribute("nextPage", (Object)nextPage);
        this.request_.setAttribute("statuses", (Object)statuses);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                if (user != null) {
                    shovelService.prepareForView(user);
                    this.request_.setAttribute("user", (Object)user);
                    IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                    this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                    friendships = shovelService.prepareForView(friendships, 100, true);
                    this.request_.setAttribute("friendships", (Object)friendships);
                }
                forward = this.actionForm_.isPartial() ? "ajax" : "html";
                break;
            }
            case 2: 
            case 3: {
                forward = formatType.getId();
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    public void setStatusesForm(IStatusesForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }
}

