/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IDirectMessagesAction;
import jp.sourceforge.shovel.action.impl.DirectMessagesActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IDirectMessagesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class DirectMessagesActionImpl
implements IDirectMessagesAction {
    IDirectMessagesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;

    @Perform(CSRF=false)
    public String perform() throws Exception {
        String foreignKey;
        boolean sent;
        FormatType formatType = this.actionForm_.getFormatType();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        int page = this.actionForm_.getPage();
        int limit = this.actionForm_.getCount();
        boolean bl = sent = !this.actionForm_.isReceive();
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)this.getSession().getAttribute("listRefine");
            if (listRefine == null || !listRefine.getViewType().isInbox() && !listRefine.getViewType().isSent()) {
                listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
                this.getSession().setAttribute("listRefine", (Object)listRefine);
            } else if (this.actionForm_.getMethodType().isPage()) {
                listRefine.setPage(this.actionForm_.getPage());
            }
            listRefine.setViewType(sent ? ViewType.SENT : ViewType.INBOX);
            if (!shovelService.isMobilePhone()) {
                page = listRefine.getPage();
            }
            limit = 0;
        }
        long userId = (foreignKey = this.actionForm_.getRecipient()).matches("^[0-9]+$") ? Long.valueOf(foreignKey) : 0L;
        IUser recipient = null;
        if (userId > 0L) {
            recipient = directoryService.getUser(userId);
        } else if (foreignKey != null && foreignKey.length() > 0) {
            recipient = directoryService.getUser(foreignKey);
        }
        if (recipient != null) {
            if (recipient.getUserId() == user.getUserId()) {
                throw new ApplicationException("");
            }
            this.request_.setAttribute("recipient", (Object)recipient);
            this.request_.setAttribute("user", (Object)recipient);
            return shovelService.isMobilePhone() ? "mobile" : "full";
        }
        IDirectMessage[] temp = shovelService.getDirectMessages(sent, page, limit);
        IDirectMessage[] directMessages = shovelService.prepareForView(temp, true);
        this.request_.setAttribute("directMessages", (Object)directMessages);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                shovelService.prepareForView(user);
                this.request_.setAttribute("user", (Object)user);
                if (shovelService.isMobilePhone()) {
                    this.request_.setAttribute("page", (Object)page);
                    forward = "mobile";
                } else {
                    foreignKey = user.getForeignKey();
                    IFriendship[] followers = shovelService.getFollowers(foreignKey, false, 0, 65535);
                    followers = shovelService.prepareForView(followers, 0, false);
                    this.request_.setAttribute("followers", (Object)followers);
                    IFriendship[] friendships = shovelService.getFriends(foreignKey, 0, 100);
                    this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                    friendships = shovelService.prepareForView(friendships, 100, true);
                    this.request_.setAttribute("friendships", (Object)friendships);
                    forward = this.actionForm_.isPartial() ? "partial" : "full";
                }
                boolean nextPage = false;
                if (directMessages != null && directMessages.length > 0) {
                    nextPage = temp.length > directMessages.length;
                }
                this.request_.setAttribute("nextPage", (Object)nextPage);
                break;
            }
            case 2: 
            case 3: {
                forward = formatType.getId();
                break;
            }
            case 4: 
            case 5: {
                shovelService.outputFeed(formatType, ViewType.INBOX, user, directMessages);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    public void setDirectMessagesForm(IDirectMessagesForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }
}

