/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.MethodType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IFriendRequestsAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IFriendsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class FriendRequestsActionImpl
implements IFriendRequestsAction {
    IFriendsForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;

    @Perform(CSRF=false, login=true)
    public String perform() throws Exception {
        IUser user;
        int page = this.actionForm_.getPage();
        IListRefine listRefine = (IListRefine)this.getSession().getAttribute("listRefine");
        if (listRefine == null || !listRefine.getViewType().isFriendRequests()) {
            listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
            this.getSession().setAttribute("listRefine", (Object)listRefine);
        } else if (this.actionForm_.getMethodType() == MethodType.PAGE) {
            listRefine.setPage(this.actionForm_.getPage());
        }
        listRefine.setViewType(ViewType.FRIEND_REQUESTS);
        page = listRefine.getPage();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
            foreignKey = user.getForeignKey();
        } else {
            user = foreignKey.matches("^[0-9]+$") ? directoryService.getUser(userId) : directoryService.getUser(foreignKey);
        }
        IFriendship[] tmp = shovelService.getRequests(foreignKey, page, 0);
        IFriendship[] friends = shovelService.prepareForView(tmp, 0, true);
        this.request_.setAttribute("friendships", (Object)friends);
        shovelService.prepareForView(user);
        this.request_.setAttribute("user", (Object)user);
        if (friends != null && friends.length > 0) {
            this.request_.setAttribute("nextPage", (Object)(tmp.length > friends.length ? 1 : 0));
        }
        return this.actionForm_.isPartial() ? "partial" : "full";
    }

    public void setFriendshipForm(IFriendsForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }
}

