/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IFriendsTimelineAction;
import jp.sourceforge.shovel.action.impl.FriendsTimelineActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.apache.commons.lang.ArrayUtils;
import org.seasar.framework.container.S2Container;

public class FriendsTimelineActionImpl
implements IFriendsTimelineAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    S2Container container_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        IUser user = null;
        boolean home = false;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
            home = true;
        } else {
            user = foreignKey.matches("^[0-9]+$") ? directoryService.getUser(userId) : directoryService.getUser(foreignKey);
        }
        if (user == null) {
            throw new ApplicationException("");
        }
        FormatType formatType = this.actionForm_.getFormatType();
        boolean protect = false;
        if (!home && user.isProtect()) {
            protect = true;
            IUser login = directoryService.getLoginUser();
            if (login != null) {
                if (login.getUserId() == user.getUserId()) {
                    protect = false;
                } else {
                    IFriendship[] friends;
                    for (IFriendship tmp : friends = shovelService.getRequests(user.getUserId())) {
                        if (tmp.getRemovedTime() > 0L) continue;
                        if (tmp.getPassiveId() == user.getUserId()) {
                            protect &= !tmp.isAccept();
                            this.request_.setAttribute("friend", (Object)tmp);
                            continue;
                        }
                        protect = login.isProtect() ? (protect &= !tmp.isAccept()) : (protect &= false);
                        this.request_.setAttribute("follower", (Object)tmp);
                    }
                }
            }
        }
        int page = this.actionForm_.getPage();
        String since = this.actionForm_.getSince();
        int limit = this.actionForm_.getCount();
        IListRefine listRefine = null;
        Object[] statuses = new IStatus[]{};
        Object[] temp = null;
        IStatus status = null;
        listRefine = (IListRefine)this.getSession().getAttribute("listRefine");
        if (listRefine == null || !listRefine.getViewType().isFriendsTimeline() && !listRefine.getViewType().isRecent() && !listRefine.getViewType().isWithFriends()) {
            listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
            this.getSession().setAttribute("listRefine", (Object)listRefine);
        } else if (this.actionForm_.getMethodType().isPage()) {
            listRefine.setPage(this.actionForm_.getPage());
        }
        listRefine.setViewType(ViewType.FRIENDS_TIMELINE);
        if (!protect) {
            if (formatType.isHtml()) {
                if (!shovelService.isMobilePhone()) {
                    page = listRefine.getPage();
                }
                since = null;
                limit = 0;
                if (home) {
                    temp = shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, 1);
                    statuses = shovelService.prepareForView(temp, limit, true);
                } else {
                    int correctedLimit = 0;
                    if (formatType.isHtml()) {
                        correctedLimit = 2;
                        status = shovelService.getRecent(user.getForeignKey());
                        this.request_.setAttribute("status", (Object)status);
                    }
                    statuses = shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, correctedLimit);
                    temp = status == null ? statuses : (IStatus[])ArrayUtils.add((Object[])statuses, (Object)status);
                    shovelService.prepareForView(temp, limit, false);
                }
            } else {
                if (since == null || since.length() <= 0) {
                    since = this.request_.getHeader("If-Modified-Since");
                }
                statuses = since == null || since.length() <= 0 ? shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, 0) : shovelService.getStatuses(user.getForeignKey(), true, since, limit);
                shovelService.prepareForView((IStatus[])statuses, limit, false);
            }
        }
        this.request_.setAttribute("protect", (Object)protect);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                if (shovelService.isMobilePhone()) {
                    this.request_.setAttribute("at", (Object)this.actionForm_.getAt());
                    this.request_.setAttribute("replyId", (Object)this.actionForm_.getReplyId());
                    this.request_.setAttribute("page", (Object)page);
                    forward = "home_mobile";
                } else {
                    String notification = (String)this.getSession().getAttribute("notify");
                    this.getSession().removeAttribute("notify");
                    if (notification != null) {
                        this.request_.setAttribute("notification", (Object)notification);
                    }
                    shovelService.prepareForView(user);
                    this.request_.setAttribute("user", (Object)user);
                    IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                    this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                    friendships = shovelService.prepareForView(friendships, 100, true);
                    this.request_.setAttribute("friendships", (Object)friendships);
                    forward = this.actionForm_.isPartial() ? "home_partial" : "home_full";
                }
                listRefine.setViewType(ViewType.RECENT);
                boolean nextPage = false;
                if (statuses != null && statuses.length > 0) {
                    nextPage = temp.length > statuses.length;
                }
                this.request_.setAttribute("nextPage", (Object)nextPage);
                break;
            }
            case 2: 
            case 3: {
                forward = formatType.getId();
                break;
            }
            case 4: 
            case 5: {
                shovelService.outputFeed(formatType, ViewType.FRIENDS_TIMELINE, user, (IStatus[])statuses);
                return null;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        this.request_.setAttribute("statuses", (Object)statuses);
        return forward;
    }

    public void setStatusesForm(IStatusesForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }
}

