/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.action.ILoginAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.ILoginForm;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.HttpUtil;

public class LoginActionImpl
implements ILoginAction {
    ILoginForm actionForm_;
    IShovelService shovelService_;
    HttpServletRequest request_;
    HttpServletResponse response_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        String url;
        IUser user = this.shovelService_.getDirectoryService().login(this.actionForm_.getAccount(), this.actionForm_.getPassword(), false);
        if (user == null) {
            this.getSession().setAttribute("notification", (Object)"warning.loginFailure");
            url = "/";
        } else {
            if (!this.shovelService_.isMobilePhone()) {
                Cookie cookie = new Cookie("ShovelAccount", this.actionForm_.getAccount());
                cookie.setPath("/");
                if (this.actionForm_.isSaveAccount()) {
                    cookie.setMaxAge(604800);
                } else {
                    cookie.setMaxAge(0);
                }
                this.response_.addCookie(cookie);
            }
            if ((url = (String)this.getSession().getAttribute("loginRedirectUrl")) == null) {
                url = "/public_timeline";
            }
        }
        HttpUtil.sendRedirect((HttpServletResponse)this.response_, (String)url);
        return null;
    }

    public void setShovelService(IShovelService shovelService) {
        this.shovelService_ = shovelService;
    }

    public void setLoginForm(ILoginForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }
}

