/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.action.IResetPasswordAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IAccountForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.HttpUtil;
import jp.sourceforge.shovel.util.ShovelUtil;
import org.seasar.framework.container.S2Container;

public class ResetPasswordActionImpl
implements IResetPasswordAction {
    IAccountForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    S2Container container_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IDirectoryService directoryService = this.getShovelService().getDirectoryService();
        IUser user = directoryService.getUser(this.actionForm_.getEmail(), true);
        String token = ShovelUtil.generateToken((String)(this.actionForm_.getEmail() + ":" + user.getPassword()));
        if (token.compareTo(this.actionForm_.getToken()) != 0) {
            throw new ApplicationException("");
        }
        directoryService.updatePassword(user, this.actionForm_.getPassword());
        user = directoryService.login(user.getForeignKey(), this.actionForm_.getPassword(), false);
        if (user == null) {
            throw new ApplicationException("");
        }
        this.getSession().setAttribute("notify", (Object)"notify.resetPassword");
        HttpUtil.sendRedirect((HttpServletResponse)this.response_, (String)"/");
        return null;
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setAccountForm(IAccountForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    public HttpSession getSession() {
        return this.request_.getSession();
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

