/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.ErrorPageType;
import jp.sourceforge.shovel.action.IRootAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.form.ILoginForm;
import jp.sourceforge.shovel.mobilephone.IMobilePhone;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.HttpUtil;
import org.seasar.framework.container.S2Container;

public class RootActionImpl
implements IRootAction {
    IShovelService shovelService_;
    ILoginForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    S2Container container_;

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        ErrorPageType errorPageType;
        if (this.getSession().isNew() && !this.shovelService_.isMobilePhone()) {
            this.response_.sendRedirect("/");
            return null;
        }
        if (this.actionForm_.isLogout()) {
            this.shovelService_.getDirectoryService().logout();
            HttpUtil.sendRedirect((HttpServletResponse)this.response_, (String)"/");
            return null;
        }
        if (this.getSession().getAttribute("login") != null) {
            HttpUtil.sendRedirect((HttpServletResponse)this.response_, (String)"/home");
            return null;
        }
        Cookie[] cookies = this.request_.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().compareTo("ShovelAccount") != 0) continue;
                this.actionForm_.setAccount(cookie.getValue());
                this.actionForm_.setSaveAccount(true);
                break;
            }
        }
        String notification = (String)this.getSession().getAttribute("notify");
        this.getSession().removeAttribute("notify");
        if (notification != null) {
            this.request_.setAttribute("notification", (Object)notification);
        }
        if ((errorPageType = (ErrorPageType)this.request_.getAttribute("errorPageType")).isXhr()) {
            return null;
        }
        IMobilePhone mobilePhone = this.shovelService_.getMobilePhone();
        if (mobilePhone != null) {
            return "mobile_root";
        }
        return "root";
    }

    public void setShovelService(IShovelService shovelService) {
        this.shovelService_ = shovelService;
    }

    public void setLoginForm(ILoginForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }
}

