/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.ISearchUsersAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IUsersForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class SearchUsersActionImpl
implements ISearchUsersAction {
    IUsersForm actionForm_;
    ServletContext context_;
    S2Container container_;
    HttpServletRequest request_;
    HttpServletResponse response_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IListRefine listRefine = (IListRefine)this.getSession().getAttribute("listRefine");
        if (listRefine == null || !listRefine.getViewType().isSearchUsers()) {
            listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
            this.getSession().setAttribute("listRefine", (Object)listRefine);
        } else if (this.actionForm_.getMethodType().isPage()) {
            listRefine.setPage(this.actionForm_.getPage());
        }
        listRefine.setViewType(ViewType.SEARCH_USERS);
        String keyword = this.actionForm_.getKeyword();
        if (keyword == null || keyword.length() <= 0) {
            listRefine.setPage(0);
        } else {
            this.request_.setAttribute("keyword", (Object)keyword);
            int page = listRefine.getPage();
            int limit = 0;
            IUser[] temp = directoryService.searchUsers(keyword, page, limit);
            IUser[] users = shovelService.prepareForView(temp, limit);
            if (users != null && users.length > 0) {
                this.request_.setAttribute("nextPage", (Object)(temp.length > users.length ? 1 : 0));
                this.request_.setAttribute("users", (Object)users);
                long[] userIds = new long[users.length];
                int i = 0;
                for (IUser tmp : users) {
                    userIds[i++] = tmp.getUserId();
                }
                IStatus[] statuses = shovelService.getRecents(userIds);
                HashMap<String, IStatus> statusMap = new HashMap<String, IStatus>();
                for (IStatus status : statuses) {
                    String senderId = String.valueOf(status.getSenderId());
                    statusMap.put(senderId, status);
                }
                this.request_.setAttribute("statuses", statusMap);
                IUser user = directoryService.getLoginUser();
                HashMap<String, IFriendship> friendshipMap = new HashMap<String, IFriendship>();
                if (user != null) {
                    IFriendship[] friendships;
                    for (IFriendship friendship : friendships = shovelService.getFriends(userIds)) {
                        String passiveId = String.valueOf(friendship.getPassiveId());
                        friendshipMap.put(passiveId, friendship);
                    }
                }
                this.request_.setAttribute("friends", friendshipMap);
            }
        }
        return this.actionForm_.isPartial() ? "partial" : "full";
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setContext(ServletContext context) {
        this.context_ = context;
    }

    public void setUsersForm(IUsersForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

