/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.action.IUpdateAccountAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IUpdateAccountForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IServerFileService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.ServerFileUtil;
import org.apache.struts.upload.FormFile;

public class UpdateAccountActionImpl
implements IUpdateAccountAction {
    IUpdateAccountForm actionForm_;
    HttpServletRequest request_;

    @Perform(CSRF=true, administrator=true)
    public String perform() throws Exception {
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IServerFileService serverFileService = shovelService.getServerFileService();
        IUser user = directoryService.getUser(this.actionForm_.getUserId());
        user.setAdministrator(this.actionForm_.isAdministrator());
        user.setDisplayName(this.actionForm_.getDisplayName());
        user.setForeignKey(this.actionForm_.getForeignKey());
        user.setEmail(this.actionForm_.getEmail());
        user.setLocation(this.actionForm_.getLocation());
        user.setTimeZoneId(this.actionForm_.getTimeZoneId());
        user.setDescription(this.actionForm_.getDescription());
        user.setPassword(this.actionForm_.getPassword());
        user.setProtect(this.actionForm_.isProtect());
        IServerFile serverFile = user.getProfileImage();
        if (this.actionForm_.isRemoveFile() && serverFile.isExists()) {
            serverFileService.removeServerFile(serverFile);
        }
        if ((serverFile = ServerFileUtil.toServerFile((FormFile)this.actionForm_.getFile(), null, null)).isExists()) {
            serverFileService.createServerFile(serverFile, true, false);
            user.setProfileImage(serverFile);
        } else if (this.actionForm_.isRemoveFile()) {
            user.setProfileImage(serverFile);
        }
        directoryService.updateUserFromSettings(user);
        IListRefine listRefine = (IListRefine)this.getSession().getAttribute("listRefine");
        SortOrderType sortOrderType = listRefine.getSortOrderType();
        int page = listRefine.getPage();
        IUser[] temp = directoryService.getUsers(SortType.USER_ID, sortOrderType, page);
        boolean nextPage = false;
        if (temp != null && temp.length > 0) {
            IUser[] users = shovelService.prepareForView(temp, 0);
            nextPage = temp.length > users.length;
            this.request_.setAttribute("users", (Object)users);
        }
        this.request_.setAttribute("nextPage", (Object)nextPage);
        this.request_.setAttribute("callback", (Object)"window.parent.shovel.controller.onChangeConfig($('#content').html());");
        this.request_.setAttribute("template", (Object)"system/accounts.ftl");
        return "success";
    }

    public void setUpdateAccountForm(IUpdateAccountForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

