/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IUserTimelineAction;
import jp.sourceforge.shovel.action.impl.UserTimelineActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class UserTimelineActionImpl
implements IUserTimelineAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        IUser user = null;
        user = foreignKey == null || foreignKey.length() <= 0 ? directoryService.getLoginUser() : (foreignKey.matches("^[0-9]+$") ? directoryService.getUser(userId) : directoryService.getUser(foreignKey));
        if (user == null) {
            throw new ApplicationException("");
        }
        FormatType formatType = this.actionForm_.getFormatType();
        boolean protect = false;
        if (user.isProtect()) {
            protect = true;
            IUser login = directoryService.getLoginUser();
            if (login != null) {
                if (login.getUserId() == user.getUserId()) {
                    protect = false;
                } else {
                    IFriendship[] friends;
                    for (IFriendship friend : friends = shovelService.getRequests(user.getUserId())) {
                        if (friend.getRemovedTime() > 0L) continue;
                        if (friend.getPassiveId() == user.getUserId()) {
                            protect &= !friend.isAccept();
                            this.request_.setAttribute("friend", (Object)friend);
                            continue;
                        }
                        protect = login.isProtect() ? (protect &= !friend.isAccept()) : (protect &= false);
                        this.request_.setAttribute("follower", (Object)friend);
                    }
                }
            }
        }
        int page = this.actionForm_.getPage();
        String since = this.actionForm_.getSince();
        int limit = this.actionForm_.getCount();
        int correctedOffset = 0;
        int correctedLimit = 0;
        IStatus[] statuses = new IStatus[]{};
        IListRefine listRefine = (IListRefine)this.getSession().getAttribute("listRefine");
        if (listRefine == null || !listRefine.getViewType().isUserTimeline()) {
            listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
            this.getSession().setAttribute("listRefine", (Object)listRefine);
        } else if (this.actionForm_.getMethodType().isPage()) {
            listRefine.setPage(this.actionForm_.getPage());
        }
        listRefine.setViewType(ViewType.USER_TIMELINE);
        if (!protect) {
            if (formatType.isHtml()) {
                if (!shovelService.isMobilePhone()) {
                    page = listRefine.getPage();
                }
                limit = 0;
                if (page > 0) {
                    correctedOffset = 1;
                }
                correctedLimit = 2;
                statuses = shovelService.getStatuses(user.getForeignKey(), false, page, limit, correctedOffset, correctedLimit);
            } else {
                if (since == null || since.length() <= 0) {
                    since = this.request_.getHeader("If-Modified-Since");
                }
                statuses = since == null || since.length() <= 0 ? shovelService.getStatuses(user.getForeignKey(), false, page, limit, 0, 0) : shovelService.getStatuses(user.getForeignKey(), false, since, limit);
            }
        }
        this.request_.setAttribute("protect", (Object)protect);
        shovelService.prepareForView(statuses, limit, false);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                shovelService.prepareForView(user);
                this.request_.setAttribute("user", (Object)user);
                if (!protect) {
                    IFriendship[] friends;
                    for (IFriendship friend : friends = shovelService.getRequests(user.getUserId())) {
                        if (friend.getRemovedTime() > 0L) continue;
                        if (friend.getPassiveId() == user.getUserId()) {
                            this.request_.setAttribute("friend", (Object)friend);
                            continue;
                        }
                        this.request_.setAttribute("follower", (Object)friend);
                    }
                    IStatus[] temp = statuses;
                    int offset = 0;
                    if (shovelService.isMobilePhone()) {
                        offset = page > 0 ? 0 : 1;
                    }
                    statuses = shovelService.truncate(temp, offset, limit);
                    boolean nextPage = false;
                    if (statuses != null && statuses.length + offset < temp.length) {
                        nextPage = temp.length > statuses.length;
                    }
                    this.request_.setAttribute("nextPage", (Object)nextPage);
                }
                if (shovelService.isMobilePhone()) {
                    shovelService.prepareForView(user.getRecentlyStatus());
                    IFriendship friendship = shovelService.getFriend(user.getForeignKey());
                    this.request_.setAttribute("friendship", (Object)friendship);
                    this.request_.setAttribute("page", (Object)page);
                    forward = "mobile";
                    break;
                }
                IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                friendships = shovelService.prepareForView(friendships, 100, true);
                this.request_.setAttribute("friendships", (Object)friendships);
                forward = this.actionForm_.isPartial() ? "ajax" : "html";
                break;
            }
            case 2: 
            case 3: {
                forward = formatType.getId();
                break;
            }
            case 4: 
            case 5: {
                shovelService.outputFeed(formatType, ViewType.USER_TIMELINE, user, statuses);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        this.request_.setAttribute("statuses", (Object)statuses);
        return forward;
    }

    public void setStatusesForm(IStatusesForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }
}

