/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Properties;
import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.device.IDelayExecutor;
import jp.sourceforge.shovel.device.IDelayExecutorContext;
import jp.sourceforge.shovel.device.impl.AbstractDelayExecutorImpl;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IDirectoryLogic;
import jp.sourceforge.shovel.logic.IShovelLogic;
import org.apache.commons.lang.ArrayUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.log.Logger;

public abstract class AbstractDelayExecutorImpl
implements IDelayExecutor {
    static Logger logger = Logger.getLogger(AbstractDelayExecutorImpl.class);
    Properties properties_;
    static final String bodyFormat_ = "{0}: {1}";
    S2Container container_;

    public String getDisplayName() {
        return this.properties_.getProperty("displayName");
    }

    public void setProperty(String key, String value) {
        if (this.properties_ == null) {
            this.properties_ = new Properties();
        }
        this.properties_.put(key, value);
    }

    boolean isRepeat() {
        return true;
    }

    abstract void sendMessage(IUser var1, String var2) throws ApplicationException;

    void replyMessage(IUser sender, IUser receiver, String body) throws ApplicationException {
        this.sendMessage(sender, body);
        IFriendship follower = this.getShovelLogic().getFriendship(receiver.getUserId(), sender.getUserId());
        if (follower == null || sender.isProtect() && !follower.isAccept()) {
            return;
        }
        this.sendMessage(receiver, body);
    }

    void receiveMessage(String address, String body) throws ApplicationException {
        IDirectoryLogic directoryLogic = this.getDirectoryLogic();
        IUser loginUser = directoryLogic.getUserByDevice(this.getExecutorId(), address);
        if (loginUser == null) {
            return;
        }
        IDevice device = loginUser.getDevice();
        StringBuilder message = new StringBuilder();
        if (device.getAvailabilityType().isInactivation()) {
            String releaseKey = loginUser.getReleaseKey();
            if (releaseKey.compareTo(body) == 0) {
                device.setAvailabilityType(AvailabilityType.ON);
                this.getShovelLogic().updateDevice(device);
                message.append("\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u78ba\u8a8d\u3057\u307e\u3057\u305f\u3002\n");
                message.append("\u30c7\u30d0\u30a4\u30b9\u306b\u901a\u77e5\u3092\u958b\u59cb\u3057\u307e\u3059\u3002\n");
                message.append("\u901a\u77e5\u3092\u6b62\u3081\u305f\u3044\u3068\u304d\u306f\"off\"\u3092\u9001\u3063\u3066\u304f\u3060\u3055\u3044\u3002\n");
                message.append("\u8a73\u7d30\u306b\u3064\u3044\u3066\u306f\"help\"\u3092\u9001\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                this.sendMessage(loginUser, message.toString());
            }
            return;
        }
        IShovelLogic shovelLogic = this.getShovelLogic();
        IStatusWrapper statusWrapper = shovelLogic.parseStatus(body);
        if (device.getAvailabilityType().isOff() && !statusWrapper.getStatusType().isWake()) {
            return;
        }
        String foreignKey = statusWrapper.getForeignKey();
        switch (1.$SwitchMap$jp$sourceforge$shovel$StatusType[statusWrapper.getStatusType().ordinal()]) {
            case 1: {
                IUser sender = loginUser;
                long referenceSenderId = 0L;
                if (foreignKey != null) {
                    IUser referenceSender = directoryLogic.getUserByForeignKey(foreignKey);
                    referenceSenderId = referenceSender.getUserId();
                }
                directoryLogic.incrementStatuses(sender.getUserId());
                shovelLogic.receiveStatus(statusWrapper.getText(), sender.getLocation(), "im", referenceSenderId, statusWrapper.isOpen(), sender.getUserId());
                message = null;
                break;
            }
            case 2: {
                IUser receiver = directoryLogic.getUserByForeignKey(foreignKey);
                directoryLogic.incrementDirectMessages(receiver.getUserId());
                shovelLogic.createDirectMessage(statusWrapper.getText(), "im", loginUser.getUserId(), receiver.getUserId(), false);
                message.append(foreignKey);
                message.append("\u306b\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u9001\u308a\u307e\u3057\u305f\u3002");
                break;
            }
            case 3: {
                IUser sender = directoryLogic.getUserByForeignKey(foreignKey);
                IStatus status = shovelLogic.getRecent(sender.getUserId());
                if (status == null) {
                    message.append("\u307e\u3060");
                    message.append(foreignKey);
                    message.append("\u306e\u6295\u7a3f\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                    break;
                }
                long statusId = status.getStatusId();
                IFavorite favorite = shovelLogic.getFavorite(statusId, loginUser.getUserId());
                if (favorite == null) {
                    directoryLogic.incrementFavorites(loginUser.getUserId());
                    if (status.getSenderId() != loginUser.getUserId()) {
                        directoryLogic.incrementGivenFavorites(status.getSenderId());
                    }
                    shovelLogic.createFavorite(statusId, loginUser.getUserId(), false);
                    message.append("\u300c");
                    message.append(foreignKey);
                    message.append(":");
                    message.append(status.getBody());
                    message.append("\u300d\n");
                    message.append("\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u767b\u9332\u3057\u307e\u3057\u305f\u3002");
                    break;
                }
                message.append("\u304a\u6c17\u306b\u5165\u308a\u306b\u767b\u9332\u305a\u307f\u3067\u3059\u3002");
                break;
            }
            case 4: {
                IUser active = loginUser;
                IUser passive = directoryLogic.getUserByForeignKey(foreignKey);
                IFriendship friend = shovelLogic.createFriendship(active.getUserId(), passive.getUserId(), active.isProtect(), false);
                message.append(foreignKey);
                if (passive.isProtect() && !friend.isAccept()) {
                    message.append("\u306b\u30d5\u30a9\u30ed\u30fc\u306e\u304a\u9858\u3044\u3092\u3057\u307e\u3057\u305f\u3002");
                    break;
                }
                message.append("\u3092\u30d5\u30a9\u30ed\u30fc\u3057\u307e\u3057\u305f\u3002");
                break;
            }
            case 5: {
                IUser active = loginUser;
                IUser passive = directoryLogic.getUserByForeignKey(foreignKey);
                this.getShovelLogic().destroyFriendship(active.getUserId(), passive.getUserId(), active.isProtect(), false);
                message.append(foreignKey);
                message.append("\u306e\u30d5\u30a9\u30ed\u30fc\u3092\u505c\u6b62\u3057\u307e\u3057\u305f\u3002");
                break;
            }
            case 6: {
                IUser active = loginUser;
                IUser passive = directoryLogic.getUserByForeignKey(foreignKey);
                this.getShovelLogic().updateNotification(active.getUserId(), passive.getUserId(), true);
                message.append(foreignKey);
                message.append("\u306e\u66f4\u65b0\u306e\u901a\u77e5\u3092\u518d\u958b\u3057\u307e\u3059\u3002");
                break;
            }
            case 7: {
                IUser active = loginUser;
                IUser passive = directoryLogic.getUserByForeignKey(foreignKey);
                this.getShovelLogic().updateNotification(active.getUserId(), passive.getUserId(), false);
                message.append(foreignKey);
                message.append("\u306e\u66f4\u65b0\u306e\u901a\u77e5\u3092\u505c\u6b62\u3057\u307e\u3059\u3002");
                break;
            }
            case 8: {
                device.setAvailabilityType(AvailabilityType.OFF);
                this.getShovelLogic().updateDevice(device);
                message.append("\u30c7\u30d0\u30a4\u30b9\u3078\u306e\u901a\u77e5\u3092\u505c\u6b62\u3057\u307e\u3059\u3002\n");
                message.append("\u901a\u77e5\u3092\u518d\u958b\u3057\u305f\u3044\u3068\u304d\u306f\"on\"\u3092\u9001\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                break;
            }
            case 9: {
                device.setAvailabilityType(AvailabilityType.ON);
                this.getShovelLogic().updateDevice(device);
                message.append("\u30c7\u30d0\u30a4\u30b9\u3078\u306e\u901a\u77e5\u3092\u518d\u958b\u3057\u307e\u3059\u3002\n");
                message.append("\u901a\u77e5\u3092\u505c\u6b62\u3057\u305f\u3044\u3068\u304d\u306f\"off\"\u3092\u9001\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                break;
            }
            default: {
                message = null;
            }
        }
        if (message != null) {
            this.sendMessage(loginUser, message.toString());
        }
    }

    public void execute(IDelayExecutorContext context) throws ApplicationException {
        boolean nextPage;
        if (!this.isConnected() || context.isCommit() || !context.getDelayExecutionType().isUpdateStatus()) {
            return;
        }
        IStatus status = context.getStatus();
        long senderId = status.getSenderId();
        long receiverId = status.getReferenceSenderId();
        IUser sender = this.getDirectoryLogic().getUser(senderId);
        Object[] args = new Object[]{sender.getForeignKey(), status.getBody()};
        MessageFormat formatter = new MessageFormat(bodyFormat_);
        String body = formatter.format(args);
        IUser receiver = this.getDirectoryLogic().getUser(receiverId);
        if (receiver != null) {
            this.replyMessage(sender, receiver, body);
            return;
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        if (this.isRepeat()) {
            IDevice device = sender.getDevice();
            if (this.getExecutorId().compareToIgnoreCase(device.getType()) == 0 && device.getAvailabilityType() == AvailabilityType.ON) {
                userIdSet.add(senderId);
            }
        }
        int offset = 0;
        int limit = 50;
        do {
            nextPage = false;
            Object[] followers = this.getFollowers(senderId, offset, limit + 1);
            if (followers != null && followers.length > 0) {
                boolean bl = nextPage = followers.length > limit;
                if (nextPage) {
                    offset += limit;
                    followers = (IFriendship[])ArrayUtils.subarray((Object[])followers, (int)0, (int)limit);
                }
                for (Object follower : followers) {
                    long userId = follower.getActiveId();
                    userIdSet.add(userId);
                }
            }
            userIdSet.remove(0);
            long[] userIds = ArrayUtils.toPrimitive((Long[])userIdSet.toArray(new Long[userIdSet.size()]));
            IUser[] users = this.getDirectoryLogic().getUsers(userIds);
            if (users == null || users.length <= 0) {
                return;
            }
            for (IUser user : users) {
                this.sendMessage(user, body);
            }
        } while (nextPage);
    }

    IFriendship[] getFollowers(long senderId, int offset, int limit) {
        return this.getShovelLogic().getFollowers(senderId, this.getExecutorId(), offset, limit);
    }

    abstract void login() throws ApplicationException;

    abstract void logout();

    public void connect() throws ApplicationException {
        this.login();
    }

    public void disconnect() {
        this.logout();
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    IDirectoryLogic getDirectoryLogic() {
        return (IDirectoryLogic)this.getContainer().getComponent(IDirectoryLogic.class);
    }

    IShovelLogic getShovelLogic() {
        return (IShovelLogic)this.getContainer().getComponent(IShovelLogic.class);
    }
}

