/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import java.util.Collection;
import java.util.Map;
import javax.net.SocketFactory;
import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.device.IXmppWrapper;
import jp.sourceforge.shovel.device.impl.AbstractDelayExecutorImpl;
import jp.sourceforge.shovel.device.impl.XmppWrapperImpl;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.collections.ReferenceMap;
import org.jivesoftware.smackx.packet.ChatStateExtension;
import org.jivesoftware.smackx.packet.MessageEvent;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppWrapperImpl
extends AbstractDelayExecutorImpl
implements IXmppWrapper {
    static Logger logger = Logger.getLogger(XmppWrapperImpl.class);
    static final String NS_MESSAGE_EVENT = "jabber:x:event";
    static final String NS_CHAT_STATE = "http://jabber.org/protocol/chatstates";
    Map<String, Chat> chatsByJabber_ = new ReferenceMap(0, 2);
    XMPPConnection connection_;

    public String getHost() {
        return this.properties_.getProperty("host");
    }

    public String getUserId() {
        return this.properties_.getProperty("userId");
    }

    public String getPassword() {
        return this.properties_.getProperty("password");
    }

    public int getPort() {
        return Integer.parseInt(this.properties_.getProperty("port"));
    }

    public String getServiceName() {
        return this.properties_.getProperty("serviceName");
    }

    public boolean isSasl() {
        return Boolean.parseBoolean(this.properties_.getProperty("sasl"));
    }

    public boolean isSsl() {
        return Boolean.parseBoolean(this.properties_.getProperty("ssl"));
    }

    public String getExecutorId() {
        return this.properties_.getProperty("type");
    }

    public String getAddress() {
        StringBuilder address = new StringBuilder(this.getUserId());
        address.append("@");
        address.append(this.getServiceName());
        return address.toString();
    }

    String splitJabberId(Chat chat) {
        String jabberId = chat.getParticipant();
        int endIndex = jabberId.lastIndexOf("/");
        if (endIndex == -1) {
            return jabberId;
        }
        return jabberId.substring(0, endIndex);
    }

    String splitClientId(Chat chat) {
        String jabberId = chat.getParticipant();
        int endIndex = jabberId.lastIndexOf("/");
        if (endIndex == -1) {
            return jabberId;
        }
        return jabberId.substring(endIndex);
    }

    public void chatCreated(Chat chat, boolean createdLocally) {
        chat.addMessageListener((MessageListener)this);
    }

    public void processMessage(Chat chat, Message message) {
        MessageEvent msgEvent = (MessageEvent)message.getExtension(NS_MESSAGE_EVENT);
        ChatStateExtension chatState = (ChatStateExtension)message.getExtension(NS_CHAT_STATE);
        try {
            boolean post = false;
            if (msgEvent == null) {
                if (chatState.getElementName() == "active") {
                    post = true;
                }
            } else if (msgEvent.isComposing() && (chatState == null || chatState.getElementName() == "active")) {
                post = true;
            }
            if (post) {
                String address = this.splitJabberId(chat).toLowerCase();
                this.chatsByJabber_.put(address, chat);
                this.receiveMessage(address, message.getBody());
            }
        }
        catch (ApplicationException e) {
            // empty catch block
        }
    }

    public void entriesAdded(Collection<String> addresses) {
    }

    public void entriesUpdated(Collection<String> addresses) {
    }

    public void entriesDeleted(Collection<String> addresses) {
    }

    public void presenceChanged(Presence presence) {
    }

    public void login() throws ApplicationException {
        ConnectionConfiguration config = this.getHost() != null && this.getPort() > 0 ? (this.getServiceName() == null ? new ConnectionConfiguration(this.getHost(), this.getPort()) : new ConnectionConfiguration(this.getHost(), this.getPort(), this.getServiceName())) : new ConnectionConfiguration(this.getServiceName());
        try {
            if (this.isSasl()) {
                config.setSASLAuthenticationEnabled(true);
            }
            if (this.isSsl()) {
                config.setSocketFactory((SocketFactory)new MySSLSocketFactory());
            }
            this.connection_ = new XMPPConnection(config);
            this.connection_.connect();
            this.connection_.login(this.getUserId(), this.getPassword());
        }
        catch (XMPPException e) {
            throw new ApplicationException("");
        }
        ChatManager chatManager = this.connection_.getChatManager();
        chatManager.addChatListener((ChatManagerListener)this);
        Roster roster = this.connection_.getRoster();
        roster.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
    }

    public void logout() {
        this.connection_ = null;
    }

    public boolean isConnected() {
        return this.connection_ != null && this.connection_.isConnected();
    }

    void sendMessage(IUser receiver, String body) throws ApplicationException {
        IDevice device = receiver.getDevice();
        if (this.getExecutorId().compareToIgnoreCase(device.getType()) == 0 && device.getAvailabilityType() == AvailabilityType.ON) {
            String address = receiver.getAddress();
            if (address == null || address.length() <= 0) {
                return;
            }
            try {
                Message message = new Message();
                message.setTo(address);
                message.setBody(body);
                String to = message.getTo();
                Chat chat = (Chat)this.chatsByJabber_.get(to);
                if (chat == null) {
                    ChatManager chatManager = this.connection_.getChatManager();
                    chat = chatManager.createChat(to, (MessageListener)this);
                }
                chat.sendMessage(message);
            }
            catch (XMPPException e) {
                throw new ApplicationException("");
            }
        }
    }
}

