/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.logic.impl;

import java.util.Calendar;
import java.util.TimeZone;
import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.dao.IUserCustomDao;
import jp.sourceforge.shovel.dao.IUserDao;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IDirectoryLogic;
import jp.sourceforge.shovel.util.ShovelUtil;
import org.seasar.framework.container.S2Container;

public class DirectoryLogicImpl
implements IDirectoryLogic {
    S2Container container_;

    public IUser createUser(String displayName, String foreignKey, String password, String email, long profileImageId, String location, String timeZoneId, String description, long creatorId, boolean protect) throws ApplicationException {
        long createdTime = Calendar.getInstance().getTimeInMillis();
        if (timeZoneId == null) {
            timeZoneId = TimeZone.getDefault().getID();
        }
        if (displayName == null) {
            displayName = "";
        }
        if (foreignKey == null) {
            foreignKey = "";
        }
        if (email == null) {
            email = "";
        }
        ShovelUtil.validateUser((String)displayName, (String)foreignKey, (String)email, (boolean)false);
        IUser user = (IUser)this.getContainer().getComponent(IUser.class);
        user.setCreatorId(creatorId);
        user.setCreatedTime(createdTime);
        user.setDescription(description);
        user.setDisplayName(displayName);
        user.setEmail(email);
        user.setForeignKey(foreignKey);
        user.setLocation(location);
        user.setModifierId(creatorId);
        user.setModifiedTime(createdTime);
        user.setPassword(password);
        user.setProtect(protect);
        user.setProfileImageId(profileImageId);
        user.setTimeZoneId(timeZoneId);
        user.setDefaultDesign(true);
        user.setBackgroundColorHex("00A1D9");
        user.setColorHex("000000");
        user.setNameColorHex("000000");
        user.setLinkColorHex("0000ff");
        user.setSidebarBackgroundColorHex("E0FF92");
        user.setSidebarFrameColorHex("87BC44");
        user.setTile(true);
        user.setGrowl(false);
        user.setGrowlHost("");
        user.setGrowlPassword("");
        user.setViewLines(20);
        this.getUserDao().insert(user);
        return user;
    }

    public IUser createTemporaryUser() {
        return (IUser)this.getContainer().getComponent(IUser.class);
    }

    public IUser getUser(long userId) {
        return this.getUserDao().find(userId);
    }

    public IUser getUserByForeignKey(String foreignKey) {
        return this.getUserDao().findByForeignKey(foreignKey, false);
    }

    public IUser getUserByForeignKeyOrEmail(String foreignKey, boolean email) {
        return this.getUserDao().findByForeignKey(foreignKey, email);
    }

    public IUser getUserByDevice(String deviceType, String address) {
        return this.getUserDao().findByDevice(deviceType, address);
    }

    public IUser[] getUsers(SortType sortType, SortOrderType sortOrderType, int offset, int limit) {
        return this.getUserDao().findAll(sortType, sortOrderType, offset, limit);
    }

    public IUser[] getUsers(long[] userIds) {
        if (userIds == null || userIds.length <= 0) {
            return new IUser[0];
        }
        return this.getUserDao().findAllByUser(userIds, userIds.length);
    }

    public IUser[] getUsers(String[] foreignKeys) {
        if (foreignKeys == null || foreignKeys.length <= 0) {
            return new IUser[0];
        }
        return this.getUserDao().findAllByForeignKey(foreignKeys, foreignKeys.length);
    }

    public IUser[] searchUsers(String keyword, int offset, int limit) {
        String[] keywords = keyword.split("\\s");
        if (keywords == null || keywords.length <= 0) {
            return new IUser[0];
        }
        return this.getUserCustomDao().search(keywords, offset, limit);
    }

    public IUser[] getRandUsers(boolean remove, int offset, int limit) {
        return this.getUserDao().findAllByRand(remove, offset, limit);
    }

    public int updateUser(IUser user) throws ApplicationException {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        user.setModifiedTime(modifiedTime);
        String displayName = user.getDisplayName();
        String foreignKey = user.getForeignKey();
        String email = user.getEmail();
        if (user.getUserId() == 1L) {
            foreignKey = "Administrator";
            user.setForeignKey(foreignKey);
        }
        ShovelUtil.validateUser((String)displayName, (String)foreignKey, (String)email, (boolean)false);
        return this.getUserDao().update(user);
    }

    public int updateUserFromImportCsv(IUser user) throws ApplicationException {
        if (user.getUserId() == 1L) {
            throw new ApplicationException("");
        }
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        user.setModifiedTime(modifiedTime);
        String displayName = user.getDisplayName();
        String foreignKey = user.getForeignKey();
        String email = user.getEmail();
        ShovelUtil.validateUser((String)displayName, (String)foreignKey, (String)email, (boolean)false);
        return this.getUserDao().updateFromImportCsv(user);
    }

    public int updateUserFromSettings(IUser user) throws ApplicationException {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        user.setModifiedTime(modifiedTime);
        String displayName = user.getDisplayName();
        String foreignKey = user.getForeignKey();
        if (user.getUserId() == 1L) {
            foreignKey = "Administrator";
            user.setForeignKey(foreignKey);
        }
        String email = user.getEmail();
        ShovelUtil.validateUser((String)displayName, (String)foreignKey, (String)email, (boolean)false);
        return this.getUserDao().update(user);
    }

    public int updatePicture(long userId, long serverFileId) {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        return this.getUserDao().updatePicture(userId, serverFileId, modifiedTime);
    }

    public int updatePassword(long userId, String password) {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        return this.getUserDao().updatePassword(userId, password, modifiedTime);
    }

    public int updateNotices(long userId, RepliesType repliesType, boolean newFriends, boolean reply, boolean recipientDirectMessage, boolean growl, String growlHost, String growlPassword) {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        return this.getUserDao().updateNotices(userId, repliesType, newFriends, reply, recipientDirectMessage, growl, growlHost, growlPassword, modifiedTime);
    }

    public int updateRemove(long[] userIds) {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        return this.getUserDao().updateRemove(userIds, modifiedTime, true);
    }

    public int incrementFavorites(long userId) {
        return this.getUserDao().updateIncrementFavorites(userId);
    }

    public int incrementFavorites(String foreignKey) {
        return this.getUserDao().updateIncrementFavoritesByForeignKey(foreignKey);
    }

    public int decrementFavoritesAll(long statusId) {
        return this.getUserDao().updateDecrementFavoritesAll(statusId);
    }

    public int decrementFavorites(long userId) {
        return this.getUserDao().updateDecrementFavorites(userId);
    }

    public int decrementFavorites(String foreignKey) {
        return this.getUserDao().updateDecrementFavoritesByForeignKey(foreignKey);
    }

    public int incrementGivenFavorites(long userId) {
        return this.getUserDao().updateIncrementGivenFavorites(userId);
    }

    public int incrementGivenFavorites(String foreignKey) {
        return this.getUserDao().updateIncrementGivenFavoritesByForeignKey(foreignKey);
    }

    public int decrementGivenFavorites(long userId) {
        return this.getUserDao().updateDecrementGivenFavorites(userId);
    }

    public int decrementGivenFavorites(String foreignKey) {
        return this.getUserDao().updateDecrementGivenFavoritesByForeignKey(foreignKey);
    }

    public int incrementDirectMessages(long userId) {
        return this.getUserDao().updateIncrementDirectMessages(userId);
    }

    public int incrementDirectMessages(String foreignKey) {
        return this.getUserDao().updateIncrementDirectMessagesByForeignKey(foreignKey);
    }

    public int decrementDirectMessages(long userId) {
        return this.getUserDao().updateDecrementDirectMessages(userId);
    }

    public int decrementDirectMessages(String foreignKey) {
        return this.getUserDao().updateDecrementDirectMessagesByForeignKey(foreignKey);
    }

    public int incrementStatuses(long userId) {
        return this.getUserDao().updateIncrementStatuses(userId);
    }

    public int incrementStatuses(String foreignKey) {
        return this.getUserDao().updateIncrementStatusesByForeignKey(foreignKey);
    }

    public int decrementStatuses(long userId) {
        return this.getUserDao().updateDecrementStatuses(userId);
    }

    public int decrementStatuses(String foreignKey) {
        return this.getUserDao().updateDecrementStatusesByForeignKey(foreignKey);
    }

    public S2Container getContainer() {
        return this.container_;
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    IUserDao getUserDao() {
        return (IUserDao)this.getContainer().getComponent(IUserDao.class);
    }

    IUserCustomDao getUserCustomDao() {
        return (IUserCustomDao)this.getContainer().getComponent(IUserCustomDao.class);
    }
}

