/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.logic.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.shovel.GrowlPriorityType;
import jp.sourceforge.shovel.GrowlType;
import jp.sourceforge.shovel.entity.IGrowlPacket;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.io.ByteBuilder;
import jp.sourceforge.shovel.logic.IGrowlLogic;
import jp.sourceforge.shovel.logic.impl.GrowlLogicImpl;
import org.seasar.framework.container.S2Container;

/*
 * Exception performing whole class analysis ignored.
 */
public class GrowlLogicImpl
implements IGrowlLogic {
    static final int UDP_PORT = 9887;
    static final byte PROTOCOL_VERSION = 1;
    static final String ENCODING = "UTF-8";
    S2Container container_;

    public IGrowlPacket createPacket(String application, GrowlType growlType, String password) {
        IGrowlPacket packet = (IGrowlPacket)this.getContainer().getComponent(IGrowlPacket.class);
        packet.setApplication(application);
        packet.setPassword(password);
        packet.setGrowlType(growlType);
        return packet;
    }

    public IGrowlPacket createPacket(String application, GrowlType growlType, String notification, String title, String description, GrowlPriorityType priorityType, boolean sticky, String password) {
        IGrowlPacket packet = (IGrowlPacket)this.getContainer().getComponent(IGrowlPacket.class);
        packet.setApplication(application);
        packet.setNotification(notification);
        packet.setPassword(password);
        packet.setGrowlType(growlType);
        packet.setTitle(title);
        packet.setDescription(description);
        packet.setPriorityType(priorityType);
        packet.setSticky(sticky);
        return packet;
    }

    byte[] payload(ByteBuilder bb, IGrowlPacket packet) throws ApplicationException {
        InputStream in = null;
        ApplicationException re = null;
        try {
            ByteBuilder fb = new ByteBuilder();
            fb.Append(bb.GetBytes());
            String algorithm = null;
            switch (1.$SwitchMap$jp$sourceforge$shovel$GrowlType[packet.getGrowlType().ordinal()]) {
                case 1: 
                case 2: {
                    algorithm = "MD5";
                    break;
                }
                case 3: 
                case 4: {
                    algorithm = "SHA-256";
                }
            }
            if (algorithm != null) {
                ByteBuilder bpb = new ByteBuilder();
                bpb.Append(bb.GetBytes());
                bpb.Append(packet.getPassword());
                in = new ByteArrayInputStream(bpb.GetBytes());
                MessageDigest digest = MessageDigest.getInstance(algorithm);
                byte[] bytes = new byte[4096];
                int length = 0;
                while ((length = in.read(bytes, 0, bytes.length)) >= 0) {
                    digest.update(bytes, 0, length);
                }
                byte[] checksum = digest.digest();
                fb.Append(checksum);
            }
            byte[] byArray = fb.GetBytes();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            re = new ApplicationException("");
            throw re;
        }
        catch (IOException e) {
            re = new ApplicationException("");
            throw re;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                if (re == null) {
                    throw new ApplicationException("");
                }
                throw re;
            }
        }
    }

    byte[] payloadRegistration(IGrowlPacket packet) throws ApplicationException {
        ByteBuilder nb = new ByteBuilder();
        ByteBuilder db = new ByteBuilder();
        int index = 0;
        byte notificationCount = 0;
        byte enabledNotificationCount = 0;
        Map notificationMap = packet.getNotifications();
        Set notificationEntries = notificationMap.entrySet();
        try {
            for (Map.Entry notificationEntry : notificationEntries) {
                byte[] notification = ((String)notificationEntry.getKey()).getBytes("UTF-8");
                nb.Append(notification.length);
                nb.Append(notification);
                notificationCount = (byte)(notificationCount + 1);
                if (((Boolean)notificationEntry.getValue()).booleanValue()) {
                    db.Append((byte)index);
                    enabledNotificationCount = (byte)(enabledNotificationCount + 1);
                }
                ++index;
            }
            byte[] application = packet.getApplication().getBytes("UTF-8");
            ByteBuilder bb = new ByteBuilder();
            bb.Append((byte)1);
            bb.Append(packet.getGrowlType().getId());
            bb.Append(application.length);
            bb.Append(notificationCount);
            bb.Append(enabledNotificationCount);
            bb.Append(application);
            bb.Append(nb.GetBytes());
            bb.Append(db.GetBytes());
            return this.payload(bb, packet);
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException("");
        }
    }

    byte[] payloadNotification(IGrowlPacket packet) throws ApplicationException {
        int flags = GrowlLogicImpl.ConvertPriorityFlags((GrowlPriorityType)packet.getPriorityType());
        if (packet.isSticky()) {
            flags |= 1;
        }
        ByteBuilder bb = new ByteBuilder();
        try {
            byte[] notification = packet.getNotification().getBytes("UTF-8");
            byte[] title = packet.getTitle().getBytes("UTF-8");
            byte[] description = packet.getDescription().getBytes("UTF-8");
            byte[] application = packet.getApplication().getBytes("UTF-8");
            bb.Append((byte)1);
            bb.Append(packet.getGrowlType().getId());
            bb.Append(flags);
            bb.Append(notification.length);
            bb.Append(title.length);
            bb.Append(description.length);
            bb.Append(application.length);
            bb.Append(notification);
            bb.Append(title);
            bb.Append(description);
            bb.Append(application);
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException("");
        }
        return this.payload(bb, packet);
    }

    static final int ConvertPriorityFlags(GrowlPriorityType priorityType) {
        int flags = (priorityType.getId() & 7) * 2;
        if (priorityType.getId() < 0) {
            flags |= 8;
        }
        return flags;
    }

    public void sendPacket(String host, IGrowlPacket packet) throws ApplicationException {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            byte[] bytes = null;
            switch (1.$SwitchMap$jp$sourceforge$shovel$GrowlType[packet.getGrowlType().ordinal()]) {
                case 2: 
                case 4: 
                case 5: {
                    bytes = this.payloadRegistration(packet);
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    bytes = this.payloadNotification(packet);
                    break;
                }
                default: {
                    throw new ApplicationException("");
                }
            }
            socket.send(new DatagramPacket(bytes, bytes.length, InetAddress.getByName(host), 9887));
        }
        catch (SocketException e) {
            throw new ApplicationException("");
        }
        catch (UnknownHostException e) {
            throw new ApplicationException("");
        }
        catch (IOException e) {
            throw new ApplicationException("");
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }
}

