/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.logic.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.transaction.TransactionManager;
import jp.sourceforge.shovel.SizeType;
import jp.sourceforge.shovel.ThumbnailType;
import jp.sourceforge.shovel.dao.IServerFileDao;
import jp.sourceforge.shovel.entity.GaucheGuess;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IServerFileLogic;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class ServerFileLogicImpl
implements IServerFileLogic {
    S2Container container_;
    TransactionManager transactionManager_;
    GaucheGuess guess_;

    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    private GaucheGuess getGuess() {
        if (this.guess_ == null) {
            this.guess_ = new GaucheGuess();
        }
        return this.guess_;
    }

    IServerFileDao getServerFileDao() {
        return (IServerFileDao)this.getContainer().getComponent(IServerFileDao.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createServerFile(IServerFile serverFile, boolean thumbnail, boolean detectEncoding) throws ApplicationException {
        InputStream inputStream = null;
        ApplicationException e1 = null;
        try {
            try {
                String mime;
                String charset;
                String contentType;
                block18: {
                    block17: {
                        contentType = serverFile.getContentType();
                        charset = null;
                        mime = null;
                        if (contentType == null || contentType.length() <= 0) break block17;
                        int i = contentType.indexOf(";");
                        mime = i != -1 ? contentType.substring(0, i) : contentType;
                        if (detectEncoding) {
                            Pattern pattern = Pattern.compile("^text/.*;.*charset=([a-zA-Z0-9-]+).*$");
                            Matcher matcher = pattern.matcher(contentType);
                            if (matcher.matches()) {
                                charset = matcher.group(0);
                                break block18;
                            } else {
                                pattern = Pattern.compile("^text/.*$");
                                matcher = pattern.matcher(contentType);
                                if (matcher.matches()) {
                                    inputStream = serverFile.getInputStream();
                                    int size = serverFile.getSize();
                                    charset = this.getGuess().guessJP(inputStream, size);
                                }
                            }
                        }
                        break block18;
                    }
                    mime = serverFile.getMime();
                    if (mime != null && mime.length() > 0) {
                        contentType = mime;
                        charset = serverFile.getCharset();
                        if (charset != null && charset.length() > 0) {
                            contentType = mime + ";charset=" + charset;
                        }
                    } else {
                        contentType = mime = "application/octet-stream";
                    }
                }
                long createdTime = Calendar.getInstance().getTimeInMillis();
                serverFile.setCreatedTime(createdTime);
                serverFile.setContentType(contentType);
                serverFile.setCharset(charset);
                serverFile.setMime(mime);
                serverFile.prepare();
                this.getServerFileDao().insert(serverFile);
                if (thumbnail) {
                    for (SizeType sizeType : SizeType.values()) {
                        this.createThumbnail(serverFile, sizeType);
                    }
                }
                Object var16_17 = null;
            }
            catch (ApplicationException e2) {
                e1 = e2;
                throw e1;
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException cause) {
                if (e1 != null) throw throwable;
                e1 = new ApplicationException("");
                e1.initCause((Throwable)cause);
                throw e1;
            }
        }
        try {}
        catch (IOException cause) {
            if (e1 != null) return;
            e1 = new ApplicationException("");
            e1.initCause((Throwable)cause);
            throw e1;
        }
        if (inputStream == null) return;
        inputStream.close();
    }

    public IServerFile createServerFile(String name, String contentType, int size, String charset, InputStream inputStream, boolean detectEncoding) throws ApplicationException {
        if (name == null || name.length() == 0) {
            // empty if block
        }
        if (contentType == null || contentType.length() == 0) {
            // empty if block
        }
        if (size < 0) {
            // empty if block
        }
        if (charset == null || charset.length() == 0) {
            // empty if block
        }
        if (inputStream == null) {
            // empty if block
        }
        IServerFile serverFile = (IServerFile)this.getContainer().getComponent(IServerFile.class);
        serverFile.setName(name);
        serverFile.setContentType(contentType);
        serverFile.setSize(size);
        serverFile.setCharset(charset);
        serverFile.setInputStream(inputStream);
        this.createServerFile(serverFile, true, detectEncoding);
        return serverFile;
    }

    public void createThumbnail(IServerFile serverFile, SizeType sizeType) throws ApplicationException {
        if (sizeType.isOriginal()) {
            return;
        }
        ServletContext app = (ServletContext)this.getContainer().getComponent((Object)"application");
        ThumbnailType thumbnailType = (ThumbnailType)app.getAttribute("thumbnail");
        if (thumbnailType.isShovel()) {
            serverFile.createTemporaryThumbnail(sizeType);
        } else if (thumbnailType.isImageMagick()) {
            serverFile.createThumbnail(sizeType);
        }
    }

    public int removeServerFiles(long[] serverFileIds) throws ApplicationException {
        return this.getServerFileDao().deleteAll(serverFileIds);
    }

    public int removeServerFile(long serverFileId) throws ApplicationException {
        return this.removeServerFiles(new long[]{serverFileId});
    }

    public IServerFile getServerFile(long serverFileId) {
        return this.getServerFileDao().find(serverFileId);
    }

    public IServerFile[] getServerFiles(long[] serverFileIds) {
        return this.getServerFileDao().findAll(serverFileIds, 0, serverFileIds.length);
    }

    public IServerFile[] getServerFiles(int offset, int limit) {
        return this.getServerFileDao().findAll(null, offset, limit);
    }
}

