/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.mobilephone.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.mobilephone.ISoftBank;
import jp.sourceforge.shovel.mobilephone.impl.AbstractMobilePhoneImpl;
import jp.sourceforge.shovel.mobilephone.impl.SoftBankImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SoftBankImpl
extends AbstractMobilePhoneImpl
implements ISoftBank {
    boolean packetCompliant_;
    String serialNumber_;
    String vendor_;
    String vendorVersion_;
    Map<String, String> javaInfo_;
    boolean type3G_;
    String msname_;
    static final Map<String, String> images_ = new HashMap();
    int width_;
    int height_;
    int depth_;
    boolean color_;

    public boolean isJPhone() {
        return this.isSoftBank();
    }

    public boolean isVodafone() {
        return this.isSoftBank();
    }

    public boolean isPacketCompliant() {
        return this.packetCompliant_;
    }

    public String getSerialNumber() {
        return this.serialNumber_;
    }

    public String getVendor() {
        return this.vendor_;
    }

    public String getVendorVersion() {
        return this.vendorVersion_;
    }

    public String getProfile() {
        return (String)this.javaInfo_.get("Profile");
    }

    public String getConfiguration() {
        return (String)this.javaInfo_.get("Configuration");
    }

    String getExtProfile() {
        return (String)this.javaInfo_.get("Ext-Profile");
    }

    public String getExtJProfile() {
        if (this.javaInfo_.get("Ext-J-Profile") == null) {
            return this.getExtProfile();
        }
        return (String)this.javaInfo_.get("Ext-J-Profile");
    }

    public String getExtVProfile() {
        return (String)this.javaInfo_.get("Ext-V-Profile");
    }

    public String getCarrierShortName() {
        return "S";
    }

    public String getCarrierLongName() {
        return "SoftBank";
    }

    public boolean isTypeC() {
        return !this.type3G_ && this.version_.matches("^[32]\\.\\d$");
    }

    public boolean isTypeP() {
        return !this.type3G_ && this.version_.matches("^4\\.\\d$");
    }

    public boolean isTypeW() {
        return !this.type3G_ && this.version_.matches("^5\\.\\d$");
    }

    public boolean isType3GC() {
        return this.type3G_;
    }

    public String getMsname() {
        return this.msname_;
    }

    public boolean isSoftBank() {
        return true;
    }

    public String getUID() {
        return this.getRequest().getHeader("X-JPHONE-UID");
    }

    public Map<String, String> getNumberImages() {
        return images_;
    }

    void parse() throws ApplicationException {
        String[] tokens = this.getUserAgent().split(" ");
        if (tokens == null || tokens.length <= 0) {
            throw new ApplicationException("");
        }
        Pattern pattern = Pattern.compile("^(?:(SoftBank|Semulator|Vodafone|Vemulator|J-PHONE|J-EMULATOR)/\\d\\.\\d|MOT-|MOTEMULATOR)");
        Matcher matcher = pattern.matcher(tokens[0]);
        String carrier = "Motorola";
        if (matcher.find() && matcher.groupCount() > 0 && (carrier = matcher.group(1)) == null) {
            carrier = matcher.group(0);
        }
        this.type3G_ = true;
        this.javaInfo_ = new HashMap();
        switch (1.$SwitchMap$jp$sourceforge$shovel$mobilephone$impl$SoftBankImpl$CarrierType[CarrierType.find((String)carrier).ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.parseVodafone(tokens);
                break;
            }
            case 5: 
            case 6: {
                this.parseJPhone(tokens);
                break;
            }
            case 7: 
            case 8: {
                this.parseMotorola(tokens);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        this.makeScreenInfo();
        this.msname_ = this.getRequest().getHeader("X-JPHONE-MSNAME");
    }

    void parseVodafone(String[] userAgent) throws ApplicationException {
        Pattern pattern;
        Matcher matcher;
        this.packetCompliant_ = true;
        String[] tokens = userAgent[0].split("/");
        if (tokens == null || tokens.length < 3) {
            throw new ApplicationException("");
        }
        this.name_ = tokens[0];
        this.version_ = tokens[1];
        this.rawModel_ = tokens[2];
        if (tokens.length > 4 && tokens[4] != null && tokens[4].length() > 0 && (matcher = (pattern = Pattern.compile("^SN(.+)")).matcher(tokens[4])).find()) {
            this.serialNumber_ = matcher.group(1);
        }
        if (!(matcher = (pattern = Pattern.compile("^([a-z]+)((?:[a-z]|\\d){4})", 2)).matcher(tokens[3])).find()) {
            throw new ApplicationException("");
        }
        this.vendor_ = matcher.group(1);
        this.vendorVersion_ = matcher.group(2);
        for (int i = 2; i < userAgent.length; ++i) {
            tokens = userAgent[i].split("/");
            if (tokens == null || tokens.length != 2) continue;
            this.javaInfo_.put(tokens[0], tokens[1]);
        }
    }

    void parseJPhone(String[] userAgent) throws ApplicationException {
        Matcher matcher;
        Pattern pattern;
        this.type3G_ = false;
        String[] tokens = userAgent[0].split("/");
        if (tokens == null || tokens.length < 3) {
            throw new ApplicationException("");
        }
        this.name_ = tokens[0];
        this.version_ = tokens[1];
        this.rawModel_ = tokens[2];
        if (tokens.length > 3 && tokens[3] != null && tokens[3].length() > 0) {
            pattern = Pattern.compile("^SN(.+)");
            matcher = pattern.matcher(tokens[3]);
            if (!matcher.find()) {
                throw new ApplicationException("");
            }
            this.serialNumber_ = matcher.group(1);
        }
        if (userAgent.length > 1) {
            this.packetCompliant_ = true;
            tokens = userAgent[1].split("/");
            if (tokens == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            this.vendor_ = tokens[0];
            this.vendorVersion_ = tokens[1];
            for (int i = 2; i < userAgent.length; ++i) {
                tokens = userAgent[i].split("/");
                if (tokens == null || tokens.length < 2) {
                    throw new ApplicationException("");
                }
                this.javaInfo_.put(tokens[0], tokens[1]);
            }
        } else if (this.rawModel_ != null && this.rawModel_.length() > 0) {
            pattern = Pattern.compile("V\\d+([A-Z]+)");
            matcher = pattern.matcher(this.rawModel_);
            if (matcher.find()) {
                this.vendor_ = matcher.group(1);
            }
            if ((matcher = (pattern = Pattern.compile("J-([A-Z]+)")).matcher(this.rawModel_)).find()) {
                this.vendor_ = matcher.group(1);
            }
        }
    }

    void parseMotorola(String[] userAgent) throws ApplicationException {
        this.packetCompliant_ = true;
        this.vendor_ = "MOT";
        String[] tokens = userAgent[0].split("/");
        this.rawModel_ = tokens[0];
        this.vendorVersion_ = tokens[1];
        if (this.rawModel_.compareTo("MOT-C980") == 0) {
            this.model_ = "V702sMO";
        } else if (this.rawModel_.compareTo("MOT-V980") == 0) {
            this.model_ = "V702MO";
        } else {
            throw new ApplicationException("");
        }
        for (int i = 2; i < userAgent.length; ++i) {
            tokens = userAgent[i].split("/");
            this.javaInfo_.put(tokens[0], tokens[1]);
        }
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getDepth() {
        return this.depth_;
    }

    public boolean isColor() {
        return this.color_;
    }

    void makeScreenInfo() {
        Pattern pattern;
        Matcher matcher;
        String header = this.getRequest().getHeader("X-JPHONE-DISPLAY");
        if (header != null && header.length() > 0) {
            String[] tokens = header.split("\\*");
            this.width_ = Integer.parseInt(tokens[0]);
            this.height_ = Integer.parseInt(tokens[1]);
        }
        if ((header = this.getRequest().getHeader("X-JPHONE-COLOR")) != null && header.length() > 0 && (matcher = (pattern = Pattern.compile("^([CG])(\\d+)$")).matcher(header)).matches()) {
            this.color_ = matcher.group(1).compareTo("C") == 0;
            this.depth_ = Integer.parseInt(matcher.group(2));
        }
    }

    static {
        images_.put("1", "&#xE21C;");
        images_.put("2", "&#xE21D;");
        images_.put("3", "&#xE21E;");
        images_.put("4", "&#xE21F;");
        images_.put("5", "&#xE220;");
        images_.put("6", "&#xE221;");
        images_.put("7", "&#xE222;");
        images_.put("8", "&#xE223;");
        images_.put("9", "&#xE224;");
        images_.put("0", "&#xE225;");
        images_.put("#", "&#xE210;");
    }
}

