/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.mobilephone.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.mobilephone.IWillcom;
import jp.sourceforge.shovel.mobilephone.impl.AbstractMobilePhoneImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WillcomImpl
extends AbstractMobilePhoneImpl
implements IWillcom {
    String name_ = "WILLCOM";
    String vendor_;
    String modelVersion_;
    String browserVersion_;
    int cacheSize_;
    static final Map<String, String> images_ = new HashMap();

    public boolean isAirHPhone() {
        return this.isWillcom();
    }

    public String getCarrierShortName() {
        return "W";
    }

    public String getCarrierLongName() {
        return "WILLCOM";
    }

    public boolean isWillcom() {
        return true;
    }

    public String getVendor() {
        return this.vendor_;
    }

    public String getModelVersion() {
        return this.modelVersion_;
    }

    public String getBrowserVersion() {
        return this.browserVersion_;
    }

    public int getCacheSize() {
        return this.cacheSize_;
    }

    public Map<String, String> getNumberImages() {
        return images_;
    }

    void parse() throws ApplicationException {
        Pattern pattern = Pattern.compile("^Mozilla/3\\.0\\((?:DDIPOCKET|WILLCOM);(.*)\\)");
        Matcher matcher = pattern.matcher(this.getUserAgent());
        if (!matcher.find()) {
            throw new ApplicationException("");
        }
        String[] tokens = matcher.group(1).split("/");
        if (tokens == null || tokens.length < 5) {
            throw new ApplicationException("");
        }
        this.vendor_ = tokens[0];
        this.rawModel_ = tokens[1];
        this.modelVersion_ = tokens[2];
        this.browserVersion_ = tokens[3];
        pattern = Pattern.compile("^[Cc](\\d+)");
        matcher = pattern.matcher(tokens[4]);
        if (!matcher.find()) {
            throw new ApplicationException("");
        }
        this.cacheSize_ = Integer.parseInt(matcher.group(1));
    }

    static {
        images_.put("1", "&#61631;");
        images_.put("2", "&#61632;");
        images_.put("3", "&#61633;");
        images_.put("4", "&#61634;");
        images_.put("5", "&#61635;");
        images_.put("6", "&#61636;");
        images_.put("7", "&#61637;");
        images_.put("8", "&#61638;");
        images_.put("9", "&#61639;");
        images_.put("0", "&#61630;");
        images_.put("#", "[#]");
    }
}

