/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.servlet.shovel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.sourceforge.shovel.device.IDelayExecutor;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.thread.DelayExecutorQueue;
import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShovelServlet
extends GenericServlet {
    static final long serialVersionUID = -1L;

    Map<String, IDelayExecutor> createDelayExecutorMap() {
        IDelayExecutor device;
        String value;
        String key;
        Object[] tokens;
        Set<Map.Entry<Object, Object>> entrySet = this.getProperties().entrySet();
        HashMap<String, IDelayExecutor> delayExecutorMap = new HashMap<String, IDelayExecutor>();
        for (Map.Entry<Object, Object> entry : entrySet) {
            tokens = entry.getKey().toString().split("\\.");
            key = tokens[1];
            value = entry.getValue().toString();
            device = (IDelayExecutor)delayExecutorMap.get(tokens[0]);
            if (device != null || key.compareToIgnoreCase("type") != 0) continue;
            device = (IDelayExecutor)this.getContainer().getComponent((Object)value);
            delayExecutorMap.put((String)tokens[0], device);
        }
        for (Map.Entry<Object, Object> entry : entrySet) {
            tokens = entry.getKey().toString().split("\\.");
            key = StringUtils.join((Object[])tokens, (String)".", (int)1, (int)tokens.length);
            value = entry.getValue().toString();
            device = (IDelayExecutor)delayExecutorMap.get(tokens[0]);
            if (device == null) continue;
            device.setProperty(key, value);
        }
        return delayExecutorMap;
    }

    public void init(ServletConfig config) throws ServletException {
        DelayExecutorQueue queue = this.getDelayExecutorQueue();
        for (IDelayExecutor executor : this.createDelayExecutorMap().values()) {
            try {
                executor.connect();
                queue.addDelayExecutor(executor);
            }
            catch (ApplicationException e) {}
        }
        queue.start();
    }

    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    IShovelLogic getShovelLogic() {
        return (IShovelLogic)this.getContainer().getComponent(IShovelLogic.class);
    }

    Properties getProperties() {
        return (Properties)this.getContainer().getComponent((Object)"imProperties");
    }

    DelayExecutorQueue getDelayExecutorQueue() {
        return (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
    }

    public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
    }
}

