/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.library;

import java.util.List;

public class SimulatorLibrary {
    public static boolean debug = false;
    public static final int BIG = 3;
    public static final int REG = 4;

    public static int random(int max) {
        double random = Math.random();
        int r = (int)(random * (double)max);
        return r;
    }

    public static void stock(List queue, int big, int reg, int randomMax, int maxStock) {
        int max = 0;
        int totalGameCount = 0;
        int currentGameCount = 0;
        int bigCount = 0;
        int regCount = 0;
        while (max < maxStock) {
            ++totalGameCount;
            ++currentGameCount;
            int rand = SimulatorLibrary.random(randomMax);
            if (rand < big) {
                queue.add(new Integer(3));
                if (debug) {
                    System.out.println(String.valueOf(currentGameCount) + ":BIG");
                }
                ++bigCount;
                currentGameCount = 0;
                ++max;
                continue;
            }
            if (rand >= big + reg) continue;
            queue.add(new Integer(4));
            if (debug) {
                System.out.println(String.valueOf(currentGameCount) + ":REG");
            }
            ++regCount;
            currentGameCount = 0;
            ++max;
        }
        if (debug) {
            System.out.println("BIG" + String.valueOf(bigCount) + " REG" + String.valueOf(regCount));
        }
    }

    public static int getTableIndex(int[] table, int randomMax) {
        int random = SimulatorLibrary.random(randomMax);
        int tableSize = table.length;
        int sum = 0;
        int index = 0;
        int i = 0;
        while (i < tableSize) {
            if (random < (sum += table[i])) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static int getRandomPerRange(int min, int max) {
        return SimulatorLibrary.random(max - min) + 1 + min;
    }

    public static String getDenominator(int count, int total) {
        if (count == 0 || total == 0) {
            return "0/" + total;
        }
        double denominator = (double)Math.round((double)total / (double)count * 100.0) / 100.0;
        return "1/" + String.valueOf(denominator);
    }

    public static String getPercent(int count, int total) {
        if (count == 0 || total == 0) {
            return "0.0%";
        }
        double percent = (double)Math.round((double)count / (double)total * 10000.0) / 100.0;
        return String.valueOf(percent) + "%";
    }
}

