/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Doronjo;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;

public class DoronjoMainBoard
extends AbstractMainBoard {
    private int mode = -1;
    public static final int MODE_NORMAL = 1;
    public static final int MODE_HIGH_A = 2;
    public static final int MODE_HIGH_B = 3;
    public static final int MODE_REN_50 = 4;
    public static final int MODE_REN_75 = 5;
    private boolean isDb = false;
    private int dbFloor = 0;
    private int dbCounter = 0;
    private int dbType = 0;
    public static final int DB_DB = 1;
    public static final int DB_SDB = 2;
    public static final int EVENT_BIG_NOFLAG = 20;
    public static final int EVENT_DB_START = 21;
    public static final int EVENT_DB_END = 22;
    public static final int EVENT_DB_PLUS100 = 23;
    public static final int EVENT_DB_PLUS500 = 24;
    public static final int EVENT_HIGH_START = 25;
    public static final int EVENT_HIGH_END = 26;
    public static final int EVENT_FLOOR_AT_START = 27;
    public static final int EVENT_FLOOR_AT_END = 28;
    public static final int EVENT_DB_HIT = 29;
    private int gameCountAfterBig = 0;
    private boolean isLow = false;
    private int gameCountAfterBonus = 0;
    private boolean isFloorAt = false;
    private int floorAtFloor = 0;
    private int floorAtCounter = 0;
    private int[][][] modeMoveTable = new int[][][]{new int[][]{{11424, 1632, 52480}, {11424, 1632, 52480}, {6528, 6528, 52480}, {9792, 3264, 52480}, {6528, 6528, 52480}, {9792, 3264, 52480}}, new int[][]{{28672, 4096, 32768}, {28672, 4096, 32768}, {16384, 16384, 32768}, {24576, 8192, 32768}, {16384, 16384, 32768}, {24576, 8192, 32768}}};
    private int[][] atHitTable = new int[][]{{139, 194, 165, 250, 216, 380}, {440, 440, 500, 555, 730, 1100}};
    private int[][] flagTable = new int[][]{{298, 30900, 149, 0, 33500, 540, 149}, {298, 30900, 149, 0, 33500, 540, 149}, {288, 30900, 159, 0, 33500, 540, 149}, {282, 30900, 165, 0, 33500, 540, 149}, {267, 30900, 180, 0, 33500, 540, 149}, {252, 30900, 195, 0, 33500, 540, 149}};
    public static final int FLAG_PRUM = 4;
    public static final int FLAG_BELL = 5;
    public static final int FLAG_CHERRY = 6;
    private int[][] flagTableBig = new int[][]{{7796, 21000, 35204, 1024, 512}, {7796, 21000, 35204, 1024, 512}, {7796, 21000, 35204, 1024, 512}, {7796, 21000, 35204, 1024, 512}, {7796, 21000, 35204, 1024, 512}, {7796, 21000, 35204, 1024, 512}};
    public static final int FLAG_BIG_PRUM = 2;
    public static final int FLAG_BIG_BELL = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    private int[][] flagTableJac = new int[][]{{1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}};
    int[] dummy = new int[]{0, 0, 0, 0, 0, 0};

    public void game(int flag) {
        int random256;
        if (!this.isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            this.isReplay = false;
        }
        if (this.isDb && this.dbCounter == 0) {
            this.fireEvent(21);
        }
        if (!this.isDb && !this.isFloorAt) {
            ++this.gameCountAfterBonus;
            ++this.gameCountAfterBig;
        }
        boolean isHazure = false;
        switch (flag) {
            case 0: {
                isHazure = true;
                break;
            }
            case 2: {
                if (this.isFloorAt) {
                    this.isFloorAt = false;
                    this.floorAtFloor = 0;
                    this.floorAtCounter = 0;
                    this.fireEvent(28);
                }
                this.fireCoinPlus(15);
                this.bonusGet();
                break;
            }
            case 1: {
                if (this.isDb) {
                    this.isReplay = true;
                    break;
                }
                if (SimulatorLibrary.random((int)65536) < 19040) {
                    this.isReplay = true;
                    break;
                }
                this.isReplay = false;
                isHazure = true;
                break;
            }
            case 5: {
                this.fireCoinPlus(5);
                break;
            }
            case 6: {
                this.fireCoinPlus(4);
                break;
            }
            case 4: {
                if (!this.isFloorAt && this.gameCountAfterBonus >= 1400) {
                    this.isFloorAt = true;
                    random256 = SimulatorLibrary.random((int)256);
                    this.floorAtFloor = random256 < 115 ? 50 : (random256 < 230 ? 100 : 65536);
                    this.floorAtCounter = 0;
                    this.fireEvent(27);
                }
                if (this.isDb || this.isFloorAt) {
                    this.fireCoinPlus(12);
                    break;
                }
                if (SimulatorLibrary.random((int)65536) >= 10926) break;
                this.fireCoinPlus(12);
            }
        }
        if (this.isDb) {
            ++this.dbCounter;
            if (isHazure) {
                random256 = SimulatorLibrary.random((int)256);
                if (random256 < 31) {
                    this.dbFloor += 100;
                    this.fireEvent(23);
                } else if (random256 < 32) {
                    this.dbFloor += 500;
                    this.fireEvent(24);
                }
            }
            if (this.dbCounter >= this.dbFloor) {
                this.isDb = false;
                this.dbFloor = 0;
                this.dbCounter = 0;
                this.fireEvent(22);
                this.gameCountAfterBonus = 0;
            }
        } else if (isHazure) {
            if (this.mode >= 4) {
                if (SimulatorLibrary.random((int)256) < 63) {
                    this.dbHit();
                }
            } else if (this.mode >= 2) {
                if (SimulatorLibrary.random((int)65536) < this.atHitTable[1][this.settei - 1]) {
                    this.dbHit();
                } else if (this.mode == 2 && SimulatorLibrary.random((int)256) < 8) {
                    if (this.gameCountAfterBig < 50) {
                        this.isLow = true;
                    } else {
                        this.mode = 1;
                        this.fireEvent(26);
                    }
                } else if (this.mode == 3 && SimulatorLibrary.random((int)256) < 28) {
                    this.mode = 1;
                    this.fireEvent(26);
                }
            } else if (SimulatorLibrary.random((int)65536) < this.atHitTable[0][this.settei - 1]) {
                this.dbHit();
            }
        } else if (this.mode == 1 && this.isReplay && SimulatorLibrary.random((int)256) == 0) {
            this.mode = 3;
            this.fireEvent(25);
        }
        if (this.isFloorAt) {
            ++this.floorAtCounter;
            if (this.floorAtCounter >= this.floorAtFloor) {
                this.isFloorAt = false;
                this.floorAtFloor = 0;
                this.floorAtCounter = 0;
                this.fireEvent(28);
                this.gameCountAfterBonus = 0;
            }
        }
        if (!this.isDb && this.mode == 2 && this.gameCountAfterBig > 50 && this.isLow) {
            this.mode = 1;
            this.fireEvent(26);
            this.isLow = false;
        }
    }

    private void dbHit() {
        if (this.isFloorAt) {
            this.isFloorAt = false;
            this.floorAtFloor = 0;
            this.floorAtCounter = 0;
            this.fireEvent(28);
        }
        this.fireEvent(29);
        int random128 = SimulatorLibrary.random((int)128);
        int random256 = SimulatorLibrary.random((int)256);
        if (this.mode == 1) {
            this.dbType = random128 < 120 ? 1 : 2;
        } else {
            int n = this.dbType = random128 < 85 ? 1 : 2;
        }
        if (this.mode < 4) {
            int index = -1;
            index = this.dbType == 1 ? SimulatorLibrary.getTableIndex((int[])this.modeMoveTable[0][this.settei - 1], (int)65536) : SimulatorLibrary.getTableIndex((int[])this.modeMoveTable[1][this.settei - 1], (int)65536);
            if (index == 0) {
                this.mode = 4;
            } else if (index == 1) {
                this.mode = 5;
            }
        } else if (this.mode == 4) {
            if (SimulatorLibrary.random((int)65536) < 32768) {
                this.mode = 1;
            }
        } else if (this.mode == 5 && SimulatorLibrary.random((int)65536) < 16384) {
            this.mode = 1;
        }
        this.dbFloor = this.dbType == 1 ? (random256 < 240 ? 25 : 100) : (random256 < 254 ? 100 : (random256 < 255 ? 300 : 500));
        this.isDb = true;
    }

    public void setup() {
        this.mode = -1;
        this.dbFloor = 0;
        this.dbType = -1;
    }

    public void reset() {
        super.reset();
        if (this.mode == -1) {
            this.mode = 1;
        } else if (this.mode < 4) {
            this.mode = 2;
            this.fireEvent(25);
        }
        this.gameCountAfterBig = 0;
        this.gameCountAfterBonus = 0;
        this.isLow = false;
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                if (SimulatorLibrary.random((int)16384) >= 69) break;
                if (this.mode < 4) {
                    this.mode = 4;
                } else if (this.mode < 5) {
                    this.mode = 5;
                }
                this.fireEvent(20);
                break;
            }
            case 1: {
                if (jacInCount < 2 || game > 20) {
                    this.fireCoinPlus(3);
                    this.setJacIn();
                    break;
                }
                this.fireCoinPlus(3);
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.fireCoinPlus(5);
                break;
            }
            case 4: {
                this.fireCoinPlus(4);
            }
        }
    }

    public int getCurrentBonus() {
        return 3;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int[][] getFlagTableLow() {
        return this.getFlagTableHigh();
    }

    public int[] genzanchi() {
        return this.dummy;
    }

    public int[] kasanchi() {
        return this.dummy;
    }

    public int getDbFloor() {
        return this.dbFloor;
    }

    public int getDbType() {
        return this.dbType;
    }

    public int getFloorAtFloor() {
        return this.floorAtFloor;
    }

    public boolean isFloorAt() {
        return this.isFloorAt;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isDb() {
        return this.isDb;
    }
}

