/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import java.io.*;

import net.argius.stew.*;
import net.argius.stew.io.CsvFormatter.*;

/**
 * ȈՃGNX|[gB
 */
public final class SimpleExporter extends Exporter {

    private static final String PROP_FORMAT = SimpleExporter.class.getName() + ".format";

    private final String separator;

    private PrintWriter out;
    private CsvFormatter formatter;

    /**
     * RXgN^B
     * @param os OutputStream
     * @param separator ؂蕶
     */
    public SimpleExporter(OutputStream os, String separator) {
        this(os, separator, getDefaultFormatter());
    }

    /**
     * RXgN^B
     * @param os OutputStream
     * @param separator ؂蕶
     * @param formatter CsvFormatter
     */
    public SimpleExporter(OutputStream os, String separator, CsvFormatter formatter) {
        super(os);
        this.out = new PrintWriter(os);
        this.separator = separator;
        this.formatter = formatter;
    }

    /**
     * tH[}b^̎擾B
     * @return CsvFormatter
     */
    public CsvFormatter getFormatter() {
        return formatter;
    }

    /**
     * tH[}b^̐ݒB
     * @param formatter CsvFormatter
     */
    public void setFormatter(CsvFormatter formatter) {
        this.formatter = formatter;
    }

    /**
     * ̃tH[}b^̎擾B
     * @return CsvFormatter
     */
    private static CsvFormatter getDefaultFormatter() {
        try {
            switch (FormatType.of(LocalSystem.getProperty(PROP_FORMAT).toUpperCase())) {
                case STRING:
                    return CsvFormatter.STRING;
                case ESCAPE:
                    return CsvFormatter.ESCAPE;
                case AUTO:
                    return CsvFormatter.AUTO;
                case RAW:
                default:
                    return CsvFormatter.RAW;
            }
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addRow(Object[] values) throws IOException {
        ensureOpen();
        for (int i = 0; i < values.length; i++) {
            Object o = values[i];
            if (i > 0) {
                out.print(separator);
            }
            String value;
            if (o instanceof String) {
                value = (String)o;
            } else if (values[i] != null) {
                value = o.toString();
            } else {
                value = "";
            }
            out.print(formatter.format(value));
        }
        out.println();
        out.flush();
    }

    @Override
    public void close() throws IOException {
        ensureOpen();
        try {
            if (out != null) {
                out.flush();
                out.close();
            }
        } finally {
            out = null;
            super.close();
        }
    }

}
