/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.argius.stew.Iteration;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.TextSearch;

final class WindowLauncher2 {
    private WindowLauncher2() {
    }

    static TextSearch createTextSearch(final DatabaseInfoTree databaseInfoTree) {
        return new TextSearch(){

            public boolean search(TextSearch.Matcher matcher) {
                return this.search(databaseInfoTree.getSelectionPath(), matcher);
            }

            private boolean search(TreePath treePath, TextSearch.Matcher matcher) {
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                if (treeNode == null) {
                    return false;
                }
                boolean bl = false;
                bl = matcher.find(treeNode.toString());
                if (bl) {
                    databaseInfoTree.addSelectionPath(treePath);
                } else {
                    databaseInfoTree.removeSelectionPath(treePath);
                }
                if (!treeNode.isLeaf() && treeNode.getChildCount() >= 0) {
                    Iterable<? extends TreeNode> iterable = Iteration.asIterable(treeNode.children());
                    for (DefaultMutableTreeNode defaultMutableTreeNode : iterable) {
                        if (!this.search(treePath.pathByAddingChild(defaultMutableTreeNode), matcher)) continue;
                        bl = true;
                    }
                }
                return bl;
            }

            public void reset() {
            }
        };
    }

    static TextSearch createTextSearch(final ResultSetTable resultSetTable) {
        return new TextSearch(){

            public boolean search(TextSearch.Matcher matcher) {
                int n = resultSetTable.getRowCount();
                if (n <= 0) {
                    return false;
                }
                int n2 = resultSetTable.getColumnCount();
                boolean bl = matcher.isBackward();
                int n3 = bl ? -1 : 1;
                int n4 = bl ? n - 1 : 0;
                int n5 = bl ? 0 : n - 1;
                int n6 = bl ? n2 - 1 : 0;
                int n7 = bl ? 0 : n2 - 1;
                int n8 = n4;
                int n9 = n6;
                if (resultSetTable.getSelectedColumnCount() > 0) {
                    n9 = resultSetTable.getSelectedColumn();
                    n8 = resultSetTable.getSelectedRow() + n3;
                    if (bl) {
                        if (n8 < 0) {
                            if (--n9 < 0) {
                                return false;
                            }
                            n8 = n4;
                        }
                    } else if (n8 >= n) {
                        if (++n9 >= n2) {
                            return false;
                        }
                        n8 = n4;
                    }
                }
                TableModel tableModel = resultSetTable.getModel();
                while (bl ? n9 >= n7 : n9 <= n7) {
                    while (bl ? n8 >= n5 : n8 <= n5) {
                        if (matcher.find(String.valueOf(tableModel.getValueAt(n8, n9)))) {
                            resultSetTable.changeSelection(n8, n9, false, false);
                            return true;
                        }
                        n8 += n3;
                    }
                    n8 = n4;
                    n9 += n3;
                }
                return false;
            }

            public void reset() {
            }
        };
    }

    static TextSearch createTextSearch(final ConsoleTextArea consoleTextArea) {
        return new TextSearch(){

            public boolean search(TextSearch.Matcher matcher) {
                this.removeHighlights();
                try {
                    Highlighter highlighter = consoleTextArea.getHighlighter();
                    Highlighter.HighlightPainter highlightPainter = matcher.getHighlightPainter();
                    String string = consoleTextArea.getText();
                    int n = 0;
                    boolean bl = false;
                    while (matcher.find(string, n)) {
                        bl = true;
                        int n2 = matcher.getStart();
                        highlighter.addHighlight(n2, matcher.getEnd(), highlightPainter);
                        n = n2 + 1;
                    }
                    consoleTextArea.addKeyListener(new KeyAdapter(){

                        public void keyTyped(KeyEvent keyEvent) {
                            consoleTextArea.removeKeyListener(this);
                            this.removeHighlights();
                        }
                    });
                    return bl;
                }
                catch (BadLocationException badLocationException) {
                    throw new RuntimeException(badLocationException);
                }
            }

            public void reset() {
                this.removeHighlights();
            }

            void removeHighlights() {
                for (Highlighter.Highlight highlight : consoleTextArea.getHighlighter().getHighlights()) {
                    consoleTextArea.getHighlighter().removeHighlight(highlight);
                }
            }
        };
    }
}

