/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class WindowLauncher3 {
    private static final Logger log = LoggerFactory.getLogger(WindowLauncher3.class);

    private WindowLauncher3() {
    }

    static Reader getClipboardAsReader() throws IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            return DataFlavor.stringFlavor.getReaderForText(clipboard.getContents(null));
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            if (log.isDebugEnabled()) {
                log.debug("", unsupportedFlavorException);
            }
            throw new IOException(unsupportedFlavorException.toString());
        }
    }

    static String getClipboard() throws IOException {
        Object object;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            object = clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            if (log.isDebugEnabled()) {
                log.debug("", unsupportedFlavorException);
            }
            throw new IOException(unsupportedFlavorException.toString());
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("get clipboard:[%s]", object));
        }
        return (String)object;
    }

    static void setClipboard(String string) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("set clipboard:[%s]", string));
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    static void handleError(Throwable throwable, WindowOutputProcessor windowOutputProcessor) {
        log.error("", throwable);
        windowOutputProcessor.showErrorDialog(throwable);
    }
}

