/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.io.*;

import javax.crypto.*;

import net.argius.logging.*;

/**
 * ÍgppX[h̊B
 */
public abstract class CipherPassword implements Password {

    private static final Logger log = LoggerFactory.getLogger(CipherPassword.class);

    private static String secretKey = "";

    private String transformedString;

    /* @see net.argius.stew.Password#getTransformedString() */
    public final String getTransformedString() {
        if (transformedString != null) {
            return transformedString;
        }
        return "";
    }

    /* @see net.argius.stew.Password#setTransformedString(java.lang.String) */
    public final void setTransformedString(String transformedString) {
        if (transformedString != null) {
            this.transformedString = transformedString;
        }
    }

    /* @see net.argius.stew.Password#getRowString() */
    public final String getRowString() {
        if (transformedString != null) {
            return decrypt(transformedString);
        }
        return "";
    }

    /* @see net.argius.stew.Password#setRowString(java.lang.String) */
    public final void setRowString(String rowString) {
        if (rowString != null) {
            this.transformedString = encrypt(rowString);
        }
    }

    /* @see net.argius.stew.Password#hasPassword() */
    public final boolean hasPassword() {
        return transformedString != null;
    }

    /**
     * 閧̐ݒB
     * @param secretKey 閧
     */
    public static void setSecretKey(String secretKey) {
        assert secretKey != null && secretKey.length() > 0;
        CipherPassword.secretKey = secretKey;
    }

    /**
     * ÍB
     * @param rowString 
     * @return Íꂽ
     */
    private String encrypt(String rowString) {
        try {
            Cipher cipher = getCipherInstance(secretKey, Cipher.ENCRYPT_MODE);
            byte[] encrypted = cipher.doFinal(rowString.getBytes());
            return toHexString(encrypted);
        } catch (Exception ex) {
            log.warn("", ex);
            return "";
        }
    }

    /**
     * B
     * @param cryptedString Íꂽ
     * @return 
     */
    private String decrypt(String cryptedString) {
        try {
            Cipher cipher = getCipherInstance(secretKey, Cipher.DECRYPT_MODE);
            byte[] decrypted = cipher.doFinal(toBytes(cryptedString));
            return new String(decrypted);
        } catch (Exception ex) {
            log.warn("", ex);
            return "";
        }
    }

    /**
     * oCgz16iɕϊB
     * @param bytes oCgz
     * @return oCgz16i
     */
    private static String toHexString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        for (byte b : bytes) {
            buffer.append(String.format("%02X", b & 0xFF));
        }
        return buffer.toString();
    }

    /**
     * 16ioCgzɕϊB
     * @param hexString 16i
     * @return oCgz
     */
    private static byte[] toBytes(String hexString) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < hexString.length(); i += 2) {
            String s = hexString.substring(i, i + 2);
            bos.write(Integer.parseInt(s, 16));
        }
        return bos.toByteArray();
    }

    /**
     * CipherCX^X̎擾B
     * @param key 
     * @param mode Í/
     * @return CipherCX^X
     * @see Cipher
     */
    protected abstract Cipher getCipherInstance(String key, int mode);

}