/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.command;

import java.sql.*;
import java.util.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * e[uR}hB
 * 
 * @see DatabaseMetaData#getTables(String, String, String, String[])
 */
public final class Find extends Command {

    private static final Logger log = LoggerFactory.getLogger(Find.class);

    @Override
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (!parameter.has(1)) {
            throw new UsageException(getUsage());
        }
        // 
        final String p1 = parameter.at(1);
        final String p2 = parameter.at(2);
        final String p3 = parameter.at(3);
        final String p4 = parameter.at(4);
        final String p5 = parameter.at(5);
        try {
            DatabaseMetaData dbmeta = conn.getMetaData();
            final String tableNamePattern = editNamePattern(p1);
            final String[] tableTypes = editTableType(p2);
            final String schemaNamePattern = editNamePattern(p3);
            final String catalogNamePattern = editNamePattern(p4);
            final boolean isFull = p5.equalsIgnoreCase("FULL");
            if (log.isDebugEnabled()) {
                log.debug("name   : " + tableNamePattern);
                log.debug("types  : " + (tableTypes == null ? null : Arrays.asList(tableTypes)));
                log.debug("schema : " + schemaNamePattern);
                log.debug("catalog: " + catalogNamePattern);
                log.debug("full?  : " + isFull);
            }
            // s
            ResultSet rs = dbmeta.getTables(catalogNamePattern,
                                            schemaNamePattern,
                                            tableNamePattern,
                                            tableTypes);
            try {
                ResultSetReference ref = new ResultSetReference(rs, parameter.asString());
                if (!isFull) {
                    ColumnOrder order = ref.getOrder();
                    order.addOrder(3, getColumnName("name"));
                    order.addOrder(4, getColumnName("type"));
                    order.addOrder(2, getColumnName("schema"));
                    order.addOrder(1, getColumnName("catalog"));
                }
                output(ref);
                outputMessage("i.selected", ref.getRecordCount());
            } finally {
                rs.close();
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    /**
     * 񖼂̎擾B
     * @param key L[[h
     * @return 
     */
    private String getColumnName(String key) {
        return getMessage("Find.label." + key);
    }

    /**
     * e[u^Cv̕ҏWB
     * @param pattern e[u^Cv̎wp^[
     * @return e[u^Cv̔z
     */
    private String[] editTableType(String pattern) {
        if (pattern == null || pattern.trim().length() == 0 || pattern.equals("*")) {
            return null;
        }
        return pattern.toUpperCase().split(",");
    }

    /**
     * ̃p^[̕ҏWB
     * @param pattern p^[
     * @return ҏWꂽ̃p^[
     * @throws SQLException
     */
    private String editNamePattern(String pattern) throws SQLException {
        if (pattern == null || pattern.trim().length() == 0) {
            return null;
        } else if (pattern.equals("''") || pattern.equals("\"\"")) {
            return "";
        }
        String edited = convertPattern(pattern);
        if (log.isDebugEnabled()) {
            log.debug("table-name-condition : " + edited);
        }
        return edited;
    }

}
