/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.window;

import java.sql.*;

import net.argius.stew.*;

/**
 * l̓]sB
 */
abstract class ValueTransporter {

    protected ValueTransporter() {
        // empty
    }

    static ValueTransporter getInstance(String className) {
        if (className != null && className.trim().length() > 0) {
            try {
                return DynamicLoader.newInstance(className);
            } catch (DynamicLoadingException ex) {
                // ignore
            }
        }
        return new ValueTransporter() {
            // empty
        };
    }

    /**
     * ResultSetl擾B
     * @param rs
     * @param index
     * @return
     * @throws SQLException
     */
    Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getObject(index);
    }

    /**
     * Statementɒlݒ肷B
     * @param stmt
     * @param index
     * @param o
     * @throws SQLException
     */
    void setObject(PreparedStatement stmt, int index, Object o) throws SQLException {
        stmt.setObject(index, o);
    }

}
