/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.window;

import static java.awt.event.InputEvent.*;
import static java.awt.event.KeyEvent.*;
import static javax.swing.KeyStroke.getKeyStroke;
import static net.argius.stew.Iteration.join;
import static net.argius.stew.ui.window.Resource.*;
import static net.argius.stew.ui.window.WindowLauncher3.*;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;
import java.awt.event.*;
import java.io.*;
import java.nio.channels.*;
import java.sql.*;
import java.util.*;
import java.util.List;
import java.util.Map.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import net.argius.stew.io.*;

/**
 * WindowLauncher̕R[h(1)B
 * Cxg̐ݒB
 */
final class WindowLauncher1 {

    private WindowLauncher1() {
        // empty
    }

    /**
     * DatabaseInfoTreeɃCxg蓖ĂB
     * @param tree
     * @param textArea
     */
    static void bindEvents(DatabaseInfoTree tree, final ConsoleTextArea textArea) {
        final ActionUtility actionUtility = ActionUtility.getInstance(tree);
        final String keyCopyFullName = "copy-full-name";
        final String keyRefresh = "refresh";
        final String keyGenerateWherePhrase = "generate-where-phrase";
        final String keyGenerateSelectPhrase = "generate-select-phrase";
        final String keyGenerateUpdateStatement = "generate-update-statement";
        final String keyGenerateInsertStatement = "generate-insert-statement";
        // [ANVCxg]
        tree.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                textArea.replaceSelection(e.getActionCommand());
                textArea.requestFocus();
            }

        });
        // [ReLXgj[]
        actionUtility.setContextMenu(new String[]{keyCopyFullName, keyRefresh,
                                                  keyGenerateWherePhrase, keyGenerateSelectPhrase,
                                                  keyGenerateUpdateStatement,
                                                  keyGenerateInsertStatement},
                                     "FRWSUI".toCharArray());
    }

    /**
     * ResultSetTableɃCxg蓖ĂB
     * @param rstable
     * @param op
     */
    static void bindEvents(final ResultSetTable rstable, final WindowOutputProcessor op) {
        // [ANVCxg]
        final ActionUtility actionUtility = ActionUtility.getInstance(rstable);
        final int shortcutKey = Resource.getMenuShortcutKeyMask();
        final String keyCopyWithEscape = "copyWithEscape";
        final String keyPaste = "paste";
        final String keyCopyColumnNames = "copyColumnNames";
        final String keyClearCells = "clearCells";
        final String keyAddEmptyRow = "addEmptyRow";
        final String keyInsertFromClipboard = "insertFromClipboard";
        final String keyDuplicateRows = "duplicateRows";
        final String keyLinkRowsToDatabase = "linkRowsToDatabase";
        final String keyDeleteRows = "deleteRows";
        final Action cancelTableEditAction = new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                rstable.editingCanceled(new ChangeEvent(e.getSource()));
            }

        };
        // GXP[vtŃRs[
        actionUtility.bindAction(new AbstractAction(keyCopyWithEscape) {

            public void actionPerformed(ActionEvent e) {
                List<String> rows = new ArrayList<String>();
                for (int rowIndex : rstable.getSelectedRows()) {
                    List<Object> row = new ArrayList<Object>();
                    for (int columnIndex : rstable.getSelectedColumns()) {
                        final Object o = rstable.getValueAt(rowIndex, columnIndex);
                        row.add(CsvFormatter.AUTO.format(o == null ? "" : String.valueOf(o)));
                    }
                    rows.add(join(row, TAB));
                }
                setClipboard(join(rows, EOL));
            }

        }, getKeyStroke(VK_C, shortcutKey | ALT_DOWN_MASK));
        // \t
        actionUtility.bindAction(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                try {
                    InputStream is = new ByteArrayInputStream(getClipboard().getBytes());
                    Importer importer = new SmartImporter(is, TAB);
                    try {
                        int[] selectedColumns = rstable.getSelectedColumns();
                        for (int rowIndex : rstable.getSelectedRows()) {
                            Object[] values = importer.nextRow();
                            final int limit = Math.min(selectedColumns.length, values.length);
                            for (int x = 0; x < limit; x++) {
                                rstable.setValueAt(values[x], rowIndex, selectedColumns[x]);
                            }
                        }
                    } finally {
                        importer.close();
                    }
                    rstable.repaint();
                } catch (Exception ex) {
                    handleError(ex, op);
                } finally {
                    cancelTableEditAction.actionPerformed(e);
                }
            }

        }, keyPaste);
        // 񖼂Rs[
        actionUtility.bindAction(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                List<String> a = new ArrayList<String>();
                ResultSetTableModel m = rstable.getResultSetTableModel();
                for (int i = 0, n = m.getColumnCount(); i < n; i++) {
                    a.add(m.getColumnName(i));
                }
                setClipboard(join(a, TAB));
            }

        }, keyCopyColumnNames);
        // IZ̒l폜(NULLݒ)
        actionUtility.bindAction(new AbstractAction(keyClearCells) {

            public void actionPerformed(ActionEvent e) {
                try {
                    int[] selectedColumns = rstable.getSelectedColumns();
                    for (int rowIndex : rstable.getSelectedRows()) {
                        final int limit = selectedColumns.length;
                        for (int x = 0; x < limit; x++) {
                            rstable.setValueAt(null, rowIndex, selectedColumns[x]);
                        }
                    }
                    rstable.repaint();
                } catch (Exception ex) {
                    handleError(ex, op);
                } finally {
                    cancelTableEditAction.actionPerformed(e);
                }
            }

        }, getKeyStroke(VK_DELETE, 0));
        // Vs(񃊃N)ǉ
        actionUtility.bindAction(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                ResultSetTableModel m = rstable.getResultSetTableModel();
                final int selectedRow = rstable.getSelectedRow();
                if (selectedRow >= 0) {
                    m.insertUnlinkedRow(selectedRow + 1, new Object[m.getColumnCount()]);
                } else {
                    m.addUnlinkedRow(new Object[m.getColumnCount()]);
                }
            }

        }, keyAddEmptyRow);
        // Nbv{[h}
        actionUtility.bindAction(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                try {
                    Importer importer = new SmartImporter(getClipboardAsReader(), TAB);
                    try {
                        ResultSetTableModel m = rstable.getResultSetTableModel();
                        while (true) {
                            Object[] row = importer.nextRow();
                            if (row.length == 0) {
                                break;
                            }
                            m.addUnlinkedRow(row);
                            m.linkRow(m.getRowCount() - 1);
                        }
                        rstable.repaintRowHeader("model");
                    } finally {
                        importer.close();
                    }
                } catch (Exception ex) {
                    handleError(ex, op);
                } finally {
                    cancelTableEditAction.actionPerformed(e);
                }
            }

        }, keyInsertFromClipboard);
        // Is𕡐Ēǉ
        actionUtility.bindAction(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                ResultSetTableModel m = rstable.getResultSetTableModel();
                List<?> rows = m.getDataVector();
                int[] selectedRows = rstable.getSelectedRows();
                int index = selectedRows[selectedRows.length - 1];
                for (int rowIndex : selectedRows) {
                    m.insertUnlinkedRow(++index, (Vector<?>)((Vector<?>)rows.get(rowIndex)).clone());
                }
                rstable.repaint();
                rstable.repaintRowHeader("model");
            }

        },
                                 keyDuplicateRows);
        // 񃊃NsDBƃN
        actionUtility.bindAction(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                ResultSetTableModel m = rstable.getResultSetTableModel();
                try {
                    for (int rowIndex : rstable.getSelectedRows()) {
                        m.linkRow(rowIndex);
                    }
                } catch (SQLException ex) {
                    throw new RuntimeException(ex);
                } finally {
                    rstable.repaintRowHeader("unlinkedRowStatus");
                }
            }

        }, keyLinkRowsToDatabase);
        // Is폜
        actionUtility.bindAction(new AbstractAction(keyDeleteRows) {

            public void actionPerformed(ActionEvent e) {
                try {
                    ResultSetTableModel m = rstable.getResultSetTableModel();
                    while (true) {
                        final int selectedRow = rstable.getSelectedRow();
                        if (selectedRow < 0) {
                            break;
                        }
                        if (m.isLinkedRow(selectedRow)) {
                            final boolean removed = m.removeLinkedRow(selectedRow);
                            assert removed;
                        } else {
                            m.removeRow(selectedRow);
                        }
                    }
                } catch (SQLException ex) {
                    throw new RuntimeException(ex);
                } finally {
                    rstable.repaintRowHeader("model");
                }
            }

        }, getKeyStroke(VK_MINUS, shortcutKey | SHIFT_DOWN_MASK));
        // בւ
        /*
         * Java5ł́AꂪƃL[쎞ɃtH[JXOB
         * Java6ł͖ĂǂB
         */
        actionUtility.bindAction(new AbstractAction("sort") {

            public void actionPerformed(ActionEvent e) {
                op.sortTable(rstable.getSelectedColumn());
            }

        }, getKeyStroke(VK_S, ALT_DOWN_MASK));
        // 񕝂̎
        actionUtility.bindAction(new AbstractAction("adjustColumnWidth") {

            public void actionPerformed(ActionEvent e) {
                op.adjustTableColumnWidth();
            }

        }, getKeyStroke(VK_SLASH, shortcutKey));
        // [ReLXgj[]
        String[] actionNames = new String[]{"copy", keyCopyWithEscape, keyPaste,
                                            keyCopyColumnNames, keyClearCells, "selectAll", "",
                                            keyAddEmptyRow, keyInsertFromClipboard,
                                            keyDuplicateRows, keyLinkRowsToDatabase, keyDeleteRows,};
        final List<String> linkActions = Arrays.asList(new String[]{keyPaste, keyClearCells,
                                                                    keyAddEmptyRow,
                                                                    keyDuplicateRows,
                                                                    keyLinkRowsToDatabase,
                                                                    keyDeleteRows,});
        final Map<String, JMenuItem> m = new LinkedHashMap<String, JMenuItem>();
        final JPopupMenu pmenu = actionUtility.createPopupMenu(actionNames,
                                                               "CWPNRA EISLD".toCharArray(),
                                                               m);
        pmenu.addPopupMenuListener(new PopupMenuListener() {

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ResultSetTableModel resultSetTableModel = rstable.getResultSetTableModel();
                final boolean linkable = resultSetTableModel.isLinkable();
                for (Entry<String, JMenuItem> entry : m.entrySet()) {
                    if (linkActions.contains(entry.getKey())) {
                        entry.getValue().setEnabled(linkable);
                    }
                }
                final boolean updatable = resultSetTableModel.isUpdatable();
                m.get(keyInsertFromClipboard).setEnabled(updatable);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                // empty
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                // empty
            }

        });
        rstable.setComponentPopupMenu(pmenu);
        // [wb_]
        // ReLXgj[
        final JTableHeader columnHeader = rstable.getTableHeader();
        final JPopupMenu pmenuCH = actionUtility.createPopupMenu(new String[]{"copy",
                                                                              keyCopyWithEscape,
                                                                              keyCopyColumnNames,
                                                                              keyAddEmptyRow,
                                                                              keyInsertFromClipboard},
                                                                 "CWNEI".toCharArray());
        final Point mousePosition = new Point();
        final JMenuItem sortMenu = new JMenuItem(new AbstractAction(getString("Action.sort", 'S')) {

            public void actionPerformed(ActionEvent e) {
                op.sortTable(rstable.getTableHeader().columnAtPoint(mousePosition));
            }

        });
        columnHeader.addMouseListener(new MouseAdapter() {

            @Override
            public void mousePressed(MouseEvent e) {
                mousePosition.setLocation(e.getPoint());
            }

        });
        sortMenu.setMnemonic('S');
        pmenuCH.insert(sortMenu, 0);
        columnHeader.setComponentPopupMenu(pmenuCH);
        // [swb_]
        // ReLXgj[
        final JTable rowHeader = rstable.getRowHeader();
        rowHeader.setComponentPopupMenu(pmenu);
    }

    /**
     * ConsoleTextAreaɃCxg蓖ĂB
     * @param textArea
     * @param launcher
     */
    static void bindEvents(final ConsoleTextArea textArea, final WindowLauncher launcher) {
        // [ANVCxg]
        final ActionUtility actionUtility = ActionUtility.getInstance(textArea);
        textArea.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                launcher.executeCommand(e.getActionCommand());
            }

        });
        // [hbvCxg]
        textArea.setDropTarget(new DropTarget(textArea, new DropTargetAdapter() {

            public void drop(DropTargetDropEvent dtde) {
                final List<File> fileList;
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
                    try {
                        @SuppressWarnings("unchecked")
                        List<File> list = (List<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
                        fileList = list;
                    } catch (UnsupportedFlavorException ex) {
                        throw new RuntimeException(ex);
                    } catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                } else {
                    throw new IllegalStateException("Transferable=" + t);
                }
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item1 = new JMenuItem(new AbstractAction(getString("Action.paste-path",
                                                                             'P')) {

                    public void actionPerformed(ActionEvent e) {
                        final String s = join(fileList, " ");
                        final int p = textArea.getCaretPosition();
                        if (textArea.isEditablePosition(p)) {
                            textArea.insert(s, p);
                        } else {
                            textArea.append(s, false);
                        }
                    }

                });
                item1.setMnemonic('P');
                menu.add(item1);
                JMenuItem item2 = new JMenuItem(new AbstractAction(getString("Action.paste-file-content",
                                                                             'F')) {

                    public void actionPerformed(ActionEvent e) {
                        try {
                            for (File file : fileList) {
                                if (file.length() > 0) {
                                    final String s = convertContentToString(file);
                                    final int p = textArea.getCaretPosition();
                                    if (textArea.isEditablePosition(p)) {
                                        textArea.insert(s, p);
                                    } else {
                                        textArea.append(s, false);
                                    }
                                }
                            }
                        } catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }

                    private String convertContentToString(File file) throws IOException {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        FileInputStream fis = new FileInputStream(file);
                        try {
                            fis.getChannel().transferTo(0, file.length(), Channels.newChannel(bos));
                        } finally {
                            fis.close();
                        }
                        return bos.toString();
                    }

                });
                item2.setMnemonic('F');
                menu.add(item2);
                Point p = dtde.getLocation();
                menu.show(textArea, p.x, p.y);
            }

        }));
        // [̑]
        // ReLXgj[+AhD
        actionUtility.setActionForTextComponent();
    }

}
