/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.window;

import java.awt.*;
import java.util.Map.*;

import javax.swing.*;
import javax.swing.UIDefaults.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * tHĝ߂Look-and-FeelB
 */
final class FontControlLookAndFeel extends BasicLookAndFeel {

    private static final LookAndFeel BASE = UIManager.getLookAndFeel();

    private final String fontFamily;
    private final int fontStyleMask;
    private final double sizeRate;

    FontControlLookAndFeel(String fontFamily, int fontStyleMask, double sizeRate) {
        this.fontFamily = fontFamily;
        this.fontStyleMask = fontStyleMask;
        this.sizeRate = sizeRate;
    }

    /**
     * tHgύXB
     * @param fontFamily tHgt@~ 
     * @param fontStyleMask tHgX^C̃}XN
     * @param sizeRate TCY̔{
     */
    static void change(String fontFamily, int fontStyleMask, double sizeRate) {
        try {
            UIManager.setLookAndFeel(new FontControlLookAndFeel(fontFamily, fontStyleMask, sizeRate));
        } catch (UnsupportedLookAndFeelException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = BASE.getDefaults();
        for (Entry<?, Object> entry : defaults.entrySet()) {
            Object key = entry.getKey();
            if (String.valueOf(key).endsWith("font")) {
                Object value = entry.getValue();
                if (value instanceof UIDefaults.ActiveValue) {
                    entry.setValue(new FontControlActiveValue((ActiveValue)value,
                                                              fontFamily,
                                                              fontStyleMask,
                                                              sizeRate));
                }
            }
        }
        return defaults;
    }

    @Override
    public String getDescription() {
        return BASE.getDescription();
    }

    @Override
    public String getID() {
        return BASE.getID();
    }

    @Override
    public String getName() {
        return BASE.getName();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return BASE.isNativeLookAndFeel();
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return BASE.isSupportedLookAndFeel();
    }

    /**
     * tHgActiveValueB
     */
    private static final class FontControlActiveValue implements ActiveValue {

        private final ActiveValue base;
        private final String fontFamily;
        private final int fontStyleMask;
        private final double sizeRate;

        FontControlActiveValue(ActiveValue base,
                               String fontFamily,
                               int fontStyleMask,
                               double sizeRate) {
            this.base = base;
            this.fontFamily = fontFamily;
            this.fontStyleMask = fontStyleMask;
            this.sizeRate = sizeRate;
        }

        /* @see javax.swing.UIDefaults.ActiveValue#createValue(javax.swing.UIDefaults) */
        public Object createValue(UIDefaults table) {
            Object o = base.createValue(table);
            if (o instanceof Font) {
                Font font = (Font)o;
                final int style = font.getStyle() & fontStyleMask;
                final int size = (int)(font.getSize() * sizeRate);
                return new FontUIResource(fontFamily, style, size);
            }
            return o;
        }

    }

}
