/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.argius.stew.ConnectorMap;
import net.argius.stew.LocalSystem;

public final class ConnectorConfiguration {
    private static final Pattern idPattern = Pattern.compile("^([^\\.]+)\\.name *=");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectorMap load() throws IOException {
        File file = ConnectorConfiguration.getPath();
        InputStream inputStream = file.exists() ? new FileInputStream(file) : new ByteArrayInputStream(new byte[0]);
        try {
            ConnectorMap connectorMap = ConnectorConfiguration.load(inputStream);
            return connectorMap;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectorMap load(InputStream inputStream) throws IOException {
        Object object;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        ArrayList<String> arrayList = new ArrayList<String>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        try {
            while ((object = bufferedReader.readLine()) != null) {
                Matcher matcher = idPattern.matcher((CharSequence)object);
                if (!matcher.find()) continue;
                arrayList.add(matcher.group(1));
            }
        }
        finally {
            bufferedReader.close();
        }
        object = new Properties();
        ((Properties)object).load(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        return new ConnectorMap(arrayList, (Properties)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(ConnectorMap connectorMap) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConnectorConfiguration.save(byteArrayOutputStream, connectorMap);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileOutputStream fileOutputStream = new FileOutputStream(ConnectorConfiguration.getPath());
        try {
            fileOutputStream.getChannel().transferFrom(Channels.newChannel(byteArrayInputStream), 0L, byArray.length);
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(OutputStream outputStream, ConnectorMap connectorMap) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        connectorMap.toProperties().store(byteArrayOutputStream, "");
        ArrayList<String> arrayList = new ArrayList<String>();
        Scanner scanner = new Scanner(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        try {
            while (scanner.hasNextLine()) {
                object = scanner.nextLine();
                if (((String)object).trim().startsWith("#")) continue;
                arrayList.add((String)object);
            }
        }
        finally {
            scanner.close();
        }
        object = new ConnectorPropertyComparator(new ArrayList<String>(connectorMap.keySet()));
        Collections.sort(arrayList, object);
        PrintWriter printWriter = new PrintWriter(outputStream);
        try {
            for (String string : arrayList) {
                printWriter.println(string);
            }
            printWriter.flush();
        }
        finally {
            printWriter.close();
        }
    }

    private static File getPath() {
        return new File(LocalSystem.getDirectory(), "connector.properties");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectorPropertyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1803584843826843857L;
        private final List<String> idList;

        ConnectorPropertyComparator(List<String> list) {
            this.idList = list;
        }

        @Override
        public int compare(String string, String string2) {
            int n;
            int n2 = this.getIdIndex(string);
            if (n2 == (n = this.getIdIndex(string2))) {
                return string.compareTo(string2);
            }
            return n2 - n;
        }

        private int getIdIndex(String string) {
            String[] stringArray = string.split("\\.", 2);
            if (stringArray.length >= 2) {
                String string2 = stringArray[0];
                return this.idList.indexOf(string2);
            }
            return -1;
        }
    }
}

