/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.util.concurrent.ThreadFactory;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;

public final class DaemonThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(DaemonThreadFactory.class);
    private static volatile int count;
    private static ThreadFactory instance;

    private DaemonThreadFactory() {
    }

    public static ThreadFactory getInstance() {
        if (instance == null) {
            instance = new DaemonThreadFactory();
        }
        return instance;
    }

    public Thread newThread(Runnable runnable) {
        String string = String.format("ChildDaemon%d-of-%s", count++, Thread.currentThread());
        if (log.isDebugEnabled()) {
            log.debug("create thread: name=" + string);
        }
        Thread thread = new Thread(runnable, string);
        thread.setDaemon(true);
        return thread;
    }

    public static void execute(Runnable runnable) {
        DaemonThreadFactory.getInstance().newThread(runnable).start();
    }
}

