/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.LocalSystem;
import net.argius.stew.Password;
import net.argius.stew.PbePassword;
import net.argius.stew.PlainTextPassword;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.ClassFinder;
import net.argius.stew.ui.window.FlexiblePanel;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class ConnectorEditDialog
extends JDialog
implements ActionUtility.ActionCommandListener {
    private static final ResourceManager res = ResourceManager.getInstance(ConnectorEditDialog.class);
    private static final int TEXT_SIZE = 32;
    private static final Insets TEXT_MARGIN = new Insets(1, 3, 1, 0);
    private static final Color COLOR_ESSENTIAL = new Color(0xFFF099);
    private static final String cmdReferToOthers = "refer-to-others";
    private static final String cmdSearchFile = "search-file";
    private static final String cmdSearchDriver = "search-driver";
    private static final String cmdSubmit = "submit";
    private static final String cmdTryToConnect = "try-to-connect";
    private static final String cmdCancel = "cancel";
    private final Connector connector;
    private final JTextField tId;
    private final JTextField tName;
    private final JTextField tClasspath;
    private final JTextField tDriver;
    private final JTextField tUrl;
    private final JTextField tUser;
    private final JPasswordField tPassword;
    private final JComboBox cPasswordClass;
    private final JCheckBox cReadOnly;
    private final JCheckBox cUsesAutoRollback;
    private List<ChangeListener> listenerList;
    private File currentDirectory;

    ConnectorEditDialog(JDialog jDialog, Connector connector) {
        super(jDialog);
        this.connector = connector;
        this.listenerList = new ArrayList<ChangeListener>();
        this.setTitle(res.get("title", new Object[0]));
        this.setDefaultCloseOperation(0);
        FlexiblePanel flexiblePanel = new FlexiblePanel();
        this.add(flexiblePanel);
        String string = connector.getId();
        this.tId = new JTextField(string, 32);
        this.tId.setEditable(false);
        this.tId.setMargin(TEXT_MARGIN);
        flexiblePanel.addComponent(new JLabel(res.get("connector.id", new Object[0])), false);
        flexiblePanel.addComponent(this.tId, true);
        this.tName = this.createJTextField(connector.getName(), false);
        flexiblePanel.addComponent(new JLabel(res.get("connector.name", new Object[0])), false);
        flexiblePanel.addComponent(this.tName, false);
        flexiblePanel.addComponent(this.createJButton(cmdReferToOthers), true);
        this.tClasspath = this.createJTextField(connector.getClasspath(), false);
        flexiblePanel.addComponent(new JLabel(res.get("connector.classpath", new Object[0])), false);
        flexiblePanel.addComponent(this.tClasspath, false);
        flexiblePanel.addComponent(this.createJButton(cmdSearchFile), true);
        this.tDriver = this.createJTextField(connector.getDriver(), false);
        flexiblePanel.addComponent(new JLabel(res.get("connector.driver", new Object[0])), false);
        flexiblePanel.addComponent(this.tDriver, false);
        flexiblePanel.addComponent(this.createJButton(cmdSearchDriver), true);
        this.tUrl = this.createJTextField(connector.getUrl(), true);
        flexiblePanel.addComponent(new JLabel(res.get("connector.url", new Object[0])), false);
        flexiblePanel.addComponent(this.tUrl, true);
        this.tUser = this.createJTextField(connector.getUser(), true);
        flexiblePanel.addComponent(new JLabel(res.get("connector.user", new Object[0])), false);
        flexiblePanel.addComponent(this.tUser, true);
        this.tPassword = new JPasswordField(32);
        this.tPassword.setBackground(COLOR_ESSENTIAL);
        this.tPassword.setMargin(TEXT_MARGIN);
        Password password = connector.getPassword();
        if (string.length() > 0 && password.hasPassword()) {
            this.tPassword.setText(password.getRowString());
        }
        flexiblePanel.addComponent(new JLabel(res.get("connector.password", new Object[0])), false);
        flexiblePanel.addComponent(this.tPassword, true);
        PasswordItem[] passwordItemArray = new PasswordItem[]{new PasswordItem(PlainTextPassword.class), new PasswordItem(PbePassword.class)};
        this.cPasswordClass = new JComboBox<PasswordItem>(passwordItemArray);
        this.cPasswordClass.setEditable(true);
        int n = -1;
        for (int i = 0; i < passwordItemArray.length; ++i) {
            if (passwordItemArray[i].getPasswordClass() != password.getClass()) continue;
            n = i;
            this.cPasswordClass.setSelectedIndex(i);
            break;
        }
        if (n < 0) {
            this.cPasswordClass.setSelectedItem(password.getClass().getName());
        }
        flexiblePanel.addComponent(new JLabel(res.get("connector.encryption", new Object[0])), false);
        flexiblePanel.addComponent(this.cPasswordClass, true);
        this.cReadOnly = new JCheckBox(res.get("connector.readonly", new Object[0]), connector.isReadOnly());
        flexiblePanel.addComponent(this.cReadOnly, true);
        this.cUsesAutoRollback = new JCheckBox(res.get("connector.autorollback", new Object[0]), connector.usesAutoRollback());
        flexiblePanel.addComponent(this.cUsesAutoRollback, true);
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 16, 0));
        jPanel.add(this.createJButton(cmdSubmit));
        jPanel.add(this.createJButton(cmdTryToConnect));
        jPanel.add(this.createJButton(cmdCancel));
        flexiblePanel.c.gridwidth = 0;
        flexiblePanel.c.insets = new Insets(12, 0, 12, 0);
        flexiblePanel.c.anchor = 10;
        flexiblePanel.addComponent(jPanel, false);
        this.pack();
        ActionUtility.bindAction(this.rootPane, this, cmdCancel, KeyStroke.getKeyStroke(27, 0));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConnectorEditDialog.this.requestClose(false);
            }
        });
    }

    public void actionCommandPerform(ActionEvent actionEvent, String string) {
        if (string.equals(cmdReferToOthers)) {
            this.referToOtherConnectors();
        } else if (string.equals(cmdSearchFile)) {
            this.chooseClasspath();
        } else if (string.equals(cmdSearchDriver)) {
            this.chooseDriverClass();
        } else if (string.equals(cmdSubmit)) {
            this.requestClose(true);
        } else if (string.equals(cmdTryToConnect)) {
            this.tryToConnect();
        } else if (string.equals(cmdCancel)) {
            this.requestClose(false);
        }
    }

    private JTextField createJTextField(String string, boolean bl) {
        JTextField jTextField = new JTextField(32);
        jTextField.setMargin(TEXT_MARGIN);
        if (string != null) {
            jTextField.setText(string);
            jTextField.setCaretPosition(0);
        }
        if (bl) {
            jTextField.setBackground(COLOR_ESSENTIAL);
        }
        ActionUtility.getInstance(jTextField).setActionForTextComponent();
        return jTextField;
    }

    private JButton createJButton(String string) {
        JButton jButton = new JButton(res.get("button." + string, new Object[0]));
        ActionUtility.bindAction(jButton, this, string, new KeyStroke[0]);
        return jButton;
    }

    void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(changeListener);
    }

    private Connector createConnector() {
        String string = this.tId.getText();
        Properties properties = new Properties();
        properties.setProperty("name", this.tName.getText());
        properties.setProperty("driver", this.tDriver.getText());
        properties.setProperty("classpath", this.tClasspath.getText());
        properties.setProperty("url", this.tUrl.getText());
        properties.setProperty("user", this.tUser.getText());
        properties.setProperty("readonly", Boolean.toString(this.cReadOnly.isSelected()));
        properties.setProperty("rollback", Boolean.toString(this.cUsesAutoRollback.isSelected()));
        properties.setProperty("password.class", this.getPasswordClassName());
        Connector connector = new Connector(string, properties);
        Password password = connector.getPassword();
        password.setRowString(String.valueOf(this.tPassword.getPassword()));
        properties.setProperty("password", password.getTransformedString());
        return new Connector(string, properties);
    }

    private String getPasswordClassName() {
        Object object = this.cPasswordClass.getSelectedItem();
        if (object != null) {
            if (object instanceof PasswordItem) {
                PasswordItem passwordItem = (PasswordItem)object;
                return passwordItem.getName();
            }
            if (object instanceof CharSequence) {
                return object.toString();
            }
        }
        return PlainTextPassword.class.getName();
    }

    void referToOtherConnectors() {
        Object object;
        ConnectorMap connectorMap;
        try {
            connectorMap = ConnectorConfiguration.load();
        }
        catch (IOException iOException) {
            WindowOutputProcessor.showErrorDialog(this, iOException);
            return;
        }
        String[] stringArray = new String[]{"id", "name", "classpath", "driver", "url", "user"};
        Vector<String[]> vector = new Vector<String[]>();
        for (Map.Entry object22 : connectorMap.entrySet()) {
            object = new Vector(stringArray.length);
            Properties properties = ((Connector)object22.getValue()).toProperties();
            properties.setProperty("id", (String)object22.getKey());
            for (String string : stringArray) {
                ((Vector)object).add(properties.getProperty(string));
            }
            vector.add((String[])object);
        }
        JTable jTable = new JTable();
        jTable.setAutoResizeMode(0);
        jTable.setSelectionMode(0);
        jTable.setDefaultEditor(Object.class, null);
        Vector<String> vector2 = new Vector<String>();
        for (String string : stringArray) {
            vector2.add(res.get("connector." + string, new Object[0]));
        }
        jTable.setModel(new DefaultTableModel(vector, vector2));
        object = new JPanel(new BorderLayout());
        ((Container)object).add((Component)new JLabel(res.get("dialog.refer-to-others.message", new Object[0])), "First");
        ((Container)object).add((Component)new JScrollPane(jTable), "Center");
        if (JOptionPane.showConfirmDialog(this, object, null, 2) != 0 || jTable.getSelectedRow() < 0) {
            return;
        }
        Properties properties = ((Connector)connectorMap.get(jTable.getValueAt(jTable.getSelectedRow(), 0))).toProperties();
        HashMap<String, JTextField> hashMap = new HashMap<String, JTextField>();
        hashMap.put("name", this.tName);
        hashMap.put("classpath", this.tClasspath);
        hashMap.put("driver", this.tDriver);
        hashMap.put("url", this.tUrl);
        hashMap.put("user", this.tUser);
        for (Map.Entry entry : hashMap.entrySet()) {
            JTextField jTextField = (JTextField)entry.getValue();
            if (jTextField.getText().trim().length() != 0) continue;
            jTextField.setText(properties.getProperty((String)entry.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void chooseClasspath() {
        Serializable serializable;
        File file;
        Container container;
        if (this.currentDirectory == null) {
            container = this;
            synchronized (container) {
                if (this.currentDirectory == null) {
                    file = new File(this.tClasspath.getText().split(File.pathSeparator)[0]);
                    if (file.isDirectory()) {
                        this.currentDirectory = file;
                    } else {
                        serializable = file.getParentFile();
                        if (serializable != null && serializable.isDirectory()) {
                            this.currentDirectory = serializable;
                        }
                    }
                }
            }
        }
        container = new JFileChooser();
        ((JFileChooser)container).setCurrentDirectory(this.currentDirectory);
        ((JFileChooser)container).setDialogTitle(res.get("dialog.search.file.header", new Object[0]));
        ((JFileChooser)container).setApproveButtonText(res.get("dialog.search.file.button", new Object[0]));
        ((JFileChooser)container).setFileSelectionMode(2);
        ((JFileChooser)container).showDialog(this, null);
        file = ((JFileChooser)container).getSelectedFile();
        if (file != null) {
            this.tClasspath.setText(file.getPath());
            serializable = this;
            synchronized (serializable) {
                this.currentDirectory = file.getParentFile();
            }
        }
    }

    void chooseDriverClass() {
        Object object;
        String string = this.tClasspath.getText();
        if (string.trim().length() == 0) {
            object = res.get("confirm.searchsystemclasspath", new Object[0]);
            if (JOptionPane.showConfirmDialog(this, object, null, 2) != 0) {
                return;
            }
            string = LocalSystem.getProperty("java.class.path");
        }
        object = new LinkedHashSet();
        for (String string2 : string.split(File.pathSeparator)) {
            URL[] uRLArray;
            File file = new File(string2);
            try {
                uRLArray = new URL[]{file.toURI().toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                continue;
            }
            ClassFinder malformedURLException = new ClassFinder(string2, (Set)object){
                final /* synthetic */ Set val$classes;
                {
                    this.val$classes = set;
                    super(string);
                }

                @Override
                public void filter(Class<?> clazz) {
                    if (Driver.class.isAssignableFrom(clazz)) {
                        this.val$classes.add(clazz.getName());
                    }
                }
            };
            URLClassLoader uRLClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(uRLArray);
                }
            });
            malformedURLException.setClassLoader(uRLClassLoader);
            malformedURLException.setFailMode(true);
            malformedURLException.find(file);
        }
        if (object.isEmpty()) {
            JOptionPane.showMessageDialog(this, res.get("search.driver.classnotfound", new Object[0]), null, 0);
        } else {
            Object[] objectArray;
            String string3 = res.get("selectDriverClass", new Object[0]);
            Object object2 = JOptionPane.showInputDialog(this, string3, "", -1, null, objectArray = object.toArray(), objectArray[0]);
            if (object2 != null) {
                this.tDriver.setText((String)object2);
                this.tDriver.setCaretPosition(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryToConnect() {
        try {
            Connector connector = this.createConnector();
            Connection connection = connector.getConnection();
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = res.get("try.connect", databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion());
                WindowOutputProcessor.showInformationMessageDialog(this, string, "");
            }
            finally {
                connection.close();
            }
        }
        catch (Throwable throwable) {
            WindowOutputProcessor.showErrorDialog(this, throwable);
        }
    }

    void requestClose(boolean bl) {
        Connector connector = this.createConnector();
        if (bl) {
            ChangeEvent changeEvent = new ChangeEvent(connector);
            for (ChangeListener changeListener : this.listenerList) {
                changeListener.stateChanged(changeEvent);
            }
        } else if (!connector.equals(this.connector) && JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-without-register", new Object[0]), null, 2) != 0) {
            return;
        }
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PasswordItem {
        final Class<? extends Password> passwordClass;

        PasswordItem(Class<? extends Password> clazz) {
            this.passwordClass = clazz;
        }

        Class<? extends Password> getPasswordClass() {
            return this.passwordClass;
        }

        String getName() {
            return this.toString();
        }

        public String toString() {
            return this.passwordClass.getName();
        }
    }
}

