/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.Environment;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.ConnectorEditDialog;
import net.argius.stew.ui.window.ConnectorEntry;
import net.argius.stew.ui.window.FlexiblePanel;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class ConnectorMapEditDialog
extends JDialog
implements ChangeListener,
ActionUtility.ActionCommandListener {
    private static final ResourceManager res = ResourceManager.getInstance(ConnectorMapEditDialog.class);
    private static final String cmdAddNew = "add-new";
    private static final String cmdModify = "modify";
    private static final String cmdRename = "rename";
    private static final String cmdRemove = "remove";
    private static final String cmdUp = "up";
    private static final String cmdDown = "down";
    private static final String cmdSubmit = "submit";
    private static final String cmdCancel = "cancel";
    private final ConnectorMap connectorMap;
    private final JList idList;
    private final DefaultListModel listModel;

    ConnectorMapEditDialog(JFrame jFrame, Environment environment) {
        super(jFrame);
        DefaultListModel<ConnectorEntry> defaultListModel = new DefaultListModel<ConnectorEntry>();
        this.connectorMap = new ConnectorMap(environment.getConnectorMap());
        this.idList = new JList(defaultListModel);
        this.listModel = defaultListModel;
        this.setTitle(res.get("title", new Object[0]));
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        FlexiblePanel flexiblePanel = new FlexiblePanel();
        flexiblePanel.c.anchor = 10;
        flexiblePanel.c.insets = new Insets(8, 12, 8, 0);
        this.add(flexiblePanel);
        final JList jList = this.idList;
        jList.setSelectionMode(0);
        for (ConnectorEntry object2 : ConnectorEntry.toList(this.connectorMap.values())) {
            defaultListModel.addElement(object2);
        }
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 31);
        jScrollPane.setWheelScrollingEnabled(true);
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() % 2 == 0) {
                    ConnectorEntry connectorEntry = (ConnectorEntry)jList.getSelectedValue();
                    ConnectorMapEditDialog.this.openConnectorEditDialog(connectorEntry.getConnector());
                }
            }
        });
        flexiblePanel.addComponent(jScrollPane, false);
        JPanel jPanel = new JPanel(new GridLayout(6, 1, 4, 2));
        jPanel.add(this.createJButton(cmdAddNew));
        jPanel.add(this.createJButton(cmdModify));
        jPanel.add(this.createJButton(cmdRename));
        jPanel.add(this.createJButton(cmdRemove));
        jPanel.add(this.createJButton(cmdUp));
        jPanel.add(this.createJButton(cmdDown));
        flexiblePanel.c.gridwidth = 0;
        flexiblePanel.c.insets = new Insets(8, 32, 8, 32);
        flexiblePanel.addComponent(jPanel, true);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 16, 8));
        jPanel2.add(this.createJButton(cmdSubmit));
        jPanel2.add(this.createJButton(cmdCancel));
        flexiblePanel.c.gridwidth = 0;
        flexiblePanel.c.fill = 0;
        flexiblePanel.addComponent(jPanel2, false);
        ActionUtility.bindAction(this.rootPane, this, cmdCancel, KeyStroke.getKeyStroke(27, 0));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConnectorMapEditDialog.this.requestClose(false);
            }
        });
    }

    public void actionCommandPerform(ActionEvent actionEvent, String string) {
        try {
            if (string.equals(cmdAddNew)) {
                String string2 = JOptionPane.showInputDialog(this, (Object)Resource.getString("i.input-new-connector-id", new Object[0]));
                if (string2 == null) {
                    return;
                }
                if (this.connectorMap.containsKey(string2)) {
                    String string3 = Resource.getString("e.id-already-exists", string2);
                    JOptionPane.showMessageDialog(this, string3, null, 0);
                } else {
                    this.openConnectorEditDialog(new Connector(string2, new Properties()));
                }
            } else if (string.equals(cmdModify)) {
                ConnectorEntry connectorEntry = (ConnectorEntry)this.idList.getSelectedValue();
                if (connectorEntry != null) {
                    this.openConnectorEditDialog(connectorEntry.getConnector());
                }
            } else if (string.equals(cmdRename)) {
                Object e = this.idList.getSelectedValue();
                if (e == null) {
                    return;
                }
                ConnectorEntry connectorEntry = (ConnectorEntry)e;
                String string4 = JOptionPane.showInputDialog(this, Resource.getString("i.input-new-connector-id", new Object[0]), connectorEntry.getId());
                if (string4 == null || string4.equals(connectorEntry.getId())) {
                    return;
                }
                this.connectorMap.remove(connectorEntry);
                this.connectorMap.put(string4, connectorEntry.getConnector());
                DefaultListModel defaultListModel = (DefaultListModel)this.idList.getModel();
                Connector connector = new Connector(string4, connectorEntry.getConnector());
                defaultListModel.set(defaultListModel.indexOf(connectorEntry), new ConnectorEntry(string4, connector));
                this.idList.repaint();
            } else if (string.equals(cmdRemove)) {
                if (JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-remove", new Object[0]), "", 2) != 0) {
                    return;
                }
                ConnectorEntry connectorEntry = (ConnectorEntry)this.idList.getSelectedValue();
                this.connectorMap.remove(connectorEntry.getId());
                DefaultListModel defaultListModel = (DefaultListModel)this.idList.getModel();
                defaultListModel.removeElement(connectorEntry);
            } else if (string.equals(cmdUp)) {
                this.shiftSelectedElementUpward();
            } else if (string.equals(cmdDown)) {
                this.shiftSelectedElementDownward();
            } else if (string.equals(cmdSubmit)) {
                this.requestClose(true);
            } else if (string.equals(cmdCancel)) {
                this.requestClose(false);
            }
        }
        catch (Exception exception) {
            WindowOutputProcessor.showErrorDialog(this, exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof Connector) {
            Connector connector = (Connector)object;
            String string = connector.getId();
            this.connectorMap.setConnector(string, connector);
            ConnectorEntry connectorEntry = new ConnectorEntry(string, connector);
            int n = this.listModel.indexOf(connectorEntry);
            if (n >= 0) {
                this.listModel.set(n, connectorEntry);
                this.idList.setSelectedIndex(n);
            } else {
                this.listModel.add(0, connectorEntry);
                this.idList.setSelectedIndex(0);
            }
        }
    }

    private JButton createJButton(String string) {
        JButton jButton = new JButton(res.get("button." + string, new Object[0]));
        ActionUtility.bindAction(jButton, this, string, new KeyStroke[0]);
        return jButton;
    }

    void openConnectorEditDialog(Connector connector) {
        ConnectorEditDialog connectorEditDialog = new ConnectorEditDialog(this, connector);
        connectorEditDialog.addChangeListener(this);
        connectorEditDialog.setModal(true);
        connectorEditDialog.setLocationRelativeTo(this.getParent());
        connectorEditDialog.setSize(connectorEditDialog.getPreferredSize());
        connectorEditDialog.setVisible(true);
    }

    void shiftSelectedElementUpward() {
        int n = this.idList.getSelectedIndex();
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        ConnectorMapEditDialog.swap(this.listModel, n, n2);
        this.idList.setSelectedIndex(n2);
        this.idList.ensureIndexIsVisible(n2);
    }

    void shiftSelectedElementDownward() {
        int n;
        int n2 = this.idList.getSelectedIndex();
        if (n2 == (n = this.listModel.getSize()) - 1) {
            return;
        }
        int n3 = n2 + 1;
        ConnectorMapEditDialog.swap(this.listModel, n2, n3);
        this.idList.setSelectedIndex(n3);
        this.idList.ensureIndexIsVisible(n3);
    }

    private static void swap(DefaultListModel defaultListModel, int n, int n2) {
        Object e = defaultListModel.get(n);
        defaultListModel.set(n, defaultListModel.get(n2));
        defaultListModel.set(n2, e);
    }

    void requestClose(boolean bl) {
        try {
            if (bl) {
                if (JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-save", new Object[0]), "", 0) != 0) {
                    return;
                }
                ConnectorMap connectorMap = new ConnectorMap();
                for (Object object : this.listModel.toArray()) {
                    ConnectorEntry connectorEntry = (ConnectorEntry)object;
                    String string = connectorEntry.getId();
                    connectorMap.setConnector(string, this.connectorMap.getConnector(string));
                }
                ConnectorConfiguration.save(connectorMap);
                this.connectorMap.clear();
                this.connectorMap.putAll(connectorMap);
            } else if (!this.connectorMap.equals(ConnectorConfiguration.load()) && JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-without-save", new Object[0]), "", 2) != 0) {
                return;
            }
            this.dispose();
        }
        catch (Exception exception) {
            WindowOutputProcessor.showErrorDialog(this, exception);
        }
    }
}

