/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

/**
 * CSV`̏o̓tH[}bgB
 *
 * ̃NX͐VȃCX^X𐶐łȂB
 */
public final class CsvFormatter {

    /**
     * tH[}bg`B
     */
    public enum FormatType {

        /**
         * ƂďoB
         * <code>=" "</code>ň͂ށB
         */
        STRING,

        /**
         * LGXP[vo͌`B
         * <code>" "</code>ň͂ށB
         * ؂蕶slƂďo͂ꍇɎgpB
         */
        ESCAPE,

        /**
         * ̎ނoo͌`B
         * 
         * A𒲂ׂĂҏW邽߁ARXgB
         * ̓Iȓ́Aȉ̂ƂB
         * <pre>
         *     s܂܂Ăꍇ - ESCAPE
         *     ؂蕶܂܂Ăꍇ - ESCAPE
         *     [Ŏn܂鐔liQȏj̏ꍇ - STRING
         *     ŉʂ̌[̐l̏ꍇ - STRING
         *     int̍ől𒴂鐔l̏ꍇ - STRING
         * </pre>
         */
        AUTO,

        /**
         * lҏWɏoB
         */
        RAW;

        static FormatType of(String s) {
            try {
                return valueOf(s);
            } catch (IllegalArgumentException ex) {
                return RAW;
            }
        }

    }

    /** @see FormatType */
    public static final CsvFormatter RAW = new CsvFormatter(FormatType.RAW);

    /** @see FormatType */
    public static final CsvFormatter STRING = new CsvFormatter(FormatType.STRING);

    /** @see FormatType */
    public static final CsvFormatter ESCAPE = new CsvFormatter(FormatType.ESCAPE);

    /** @see FormatType */
    public static final CsvFormatter AUTO = new CsvFormatter(FormatType.AUTO);

    private final FormatType type;

    private CsvFormatter(FormatType type) {
        this.type = type;
    }

    /**
     * tH[}bgB
     * @param value 
     * @return ҏWꂽ
     */
    public String format(String value) {
        switch (type) {
            case STRING:
                return editAsStringValue(value);
            case ESCAPE:
                return editAsEscapeValue(value);
            case AUTO:
                return editAuto(value);
            case RAW:
            default:
                return value;
        }
    }

    /**
     * Iɏo͌`IătH[}bgB
     * @param value l
     * @return ҏWꂽl
     */
    private String editAuto(String value) {
        // null܂͋󕶎͏Ȃ
        if (value == null || value.length() == 0) {
            return value;
        }
        // _uNH[e[Vi"j܂܂Ăꍇ - STRING
        if (value.indexOf('"') >= 0) {
            return editAsEscapeValue(value);
        }
        // s܂܂Ăꍇ - STRING
        if (value.indexOf('\r') >= 0 || value.indexOf('\n') >= 0) {
            return editAsEscapeValue(value);
        }
        final String trimmed = value.trim();
        if (trimmed.length() > 0) {
            // ܂܂Ăꍇ - STRING
            if (trimmed.indexOf(',') >= 0) {
                return editAsEscapeValue(value);
            }
            final char initial = trimmed.charAt(0);
            // [Ŏn܂鐔liQȏj̏ꍇ - QUOTE
            if (initial == '0' && trimmed.length() >= 2) {
                try {
                    Double.parseDouble(value);
                    return editAsStringValue(value);
                } catch (NumberFormatException ex) {
                    // ignore
                }
            }
            // ŉʂ̌[̐l̏ꍇ - QUOTE
            if (trimmed.indexOf('.') >= 0 && trimmed.charAt(trimmed.length() - 1) == '0') {
                try {
                    Double.parseDouble(value);
                    return editAsStringValue(value);
                } catch (NumberFormatException ex) {
                    // ignore
                }
            }
            // int̍ől𒴂鐔l̏ꍇ - QUOTE
            if ('0' <= initial && initial <= '9') {
                try {
                    if (Long.parseLong(trimmed) > Integer.MAX_VALUE) {
                        return editAsStringValue(value);
                    }
                } catch (NumberFormatException ex) {
                    return editAsStringValue(value);
                }
            }
        }
        return value;
    }

    /**
     * pꂽ`<code>(=" ")</code>ɕҏWB
     * @param value l
     * @return ҏWꂽl
     */
    private String editAsStringValue(String value) {
        return String.format("=\"%s\"", escapeQuote(value));
    }

    /**
     * J}sGXP[v`<code>(" ")</code>ɕҏWB
     * @param value l
     * @return ҏWꂽl
     */
    private String editAsEscapeValue(String value) {
        return String.format("\"%s\"", escapeQuote(value));
    }

    /**
     * pGXP[vB
     * @param string 
     * @return ҏWꂽ
     */
    private static String escapeQuote(String string) {
        return string.replaceAll("\"", "\"\"");
    }

}
