/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.argius.stew.Bootstrap;
import net.argius.stew.io.CsvFormatter;
import net.argius.stew.io.Exporter;

public final class SimpleExporter
extends Exporter {
    private static final String PROP_FORMAT = SimpleExporter.class.getName() + ".format";
    private final String separator;
    private PrintWriter out;
    private CsvFormatter formatter;

    public SimpleExporter(OutputStream outputStream, String string) {
        this(outputStream, string, SimpleExporter.getDefaultFormatter());
    }

    public SimpleExporter(OutputStream outputStream, String string, CsvFormatter csvFormatter) {
        super(outputStream);
        this.out = new PrintWriter(outputStream);
        this.separator = string;
        this.formatter = csvFormatter;
    }

    public CsvFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(CsvFormatter csvFormatter) {
        this.formatter = csvFormatter;
    }

    private static CsvFormatter getDefaultFormatter() {
        try {
            switch (CsvFormatter.FormatType.of(Bootstrap.getProperty(PROP_FORMAT).toUpperCase())) {
                case STRING: {
                    return CsvFormatter.STRING;
                }
                case ESCAPE: {
                    return CsvFormatter.ESCAPE;
                }
                case AUTO: {
                    return CsvFormatter.AUTO;
                }
            }
            return CsvFormatter.RAW;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void addRow(Object[] objectArray) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (i > 0) {
                this.out.print(this.separator);
            }
            String string = object instanceof String ? (String)object : (objectArray[i] != null ? object.toString() : "");
            this.out.print(this.formatter.format(string));
        }
        this.out.println();
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.ensureOpen();
        try {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
        finally {
            this.out = null;
            super.close();
        }
    }
}

