/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import net.argius.stew.Bootstrap;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.Utilities;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class Menu
extends JMenuBar
implements PropertyChangeListener {
    private static final ResourceManager res = ResourceManager.getInstance(Menu.class);
    private List<JMenuItem> lockingTargets = new ArrayList<JMenuItem>();
    private List<JMenuItem> unlockingTargets = new ArrayList<JMenuItem>();
    private EnumMap<Item, JMenuItem> itemToCompMap = new EnumMap(Item.class);

    Menu(AnyActionListener anyActionListener) {
        HashMap<String, JMenuItem> hashMap = new HashMap<String, JMenuItem>();
        AnyAction anyAction = new AnyAction(anyActionListener);
        for (String string : res.get("groups", new Object[0]).split(",", -1)) {
            JMenu jMenu = this.add(Menu.createJMenu(res, string));
            for (MenuElement[] menuElementArray : Menu.createJMenuItems(res, hashMap, "group." + string)) {
                if (menuElementArray == null) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                jMenu.add((JMenuItem)menuElementArray);
                String string2 = menuElementArray.getActionCommand();
                Item item = Item.of(string2);
                menuElementArray.addActionListener(anyAction);
                this.itemToCompMap.put(item, (JMenuItem)menuElementArray);
                switch (item) {
                    case closeWindow: 
                    case quit: 
                    case cut: 
                    case copy: 
                    case paste: 
                    case selectAll: 
                    case find: 
                    case clearMessage: 
                    case refresh: 
                    case widenColumnWidth: 
                    case narrowColumnWidth: 
                    case adjustColumnWidth: 
                    case autoAdjustMode: 
                    case executeCommand: 
                    case lastHistory: 
                    case nextHistory: 
                    case connect: 
                    case disconnect: 
                    case postProcessMode: 
                    case sortResult: 
                    case exportFile: {
                        this.lockingTargets.add((JMenuItem)menuElementArray);
                        break;
                    }
                    case breakCommand: {
                        this.unlockingTargets.add((JMenuItem)menuElementArray);
                        break;
                    }
                }
            }
        }
        for (JMenuItem jMenuItem : Arrays.asList(this.itemToCompMap.get((Object)Item.autoAdjustMode), this.itemToCompMap.get((Object)Item.postProcessMode))) {
            for (MenuElement menuElement : jMenuItem.getSubElements()) {
                for (MenuElement menuElement2 : menuElement.getSubElements()) {
                    JMenuItem jMenuItem2 = (JMenuItem)menuElement2;
                    jMenuItem2.addActionListener(anyAction);
                    this.itemToCompMap.put(Item.of(jMenuItem2.getActionCommand()), jMenuItem2);
                }
            }
        }
        Menu.refreshAllAccelerators(hashMap);
        this.setEnabledStates(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        String string2 = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (object instanceof JLabel && string2.equals("ancestor")) {
            this.itemToCompMap.get((Object)Item.showStatusBar).setSelected(((JLabel)object).isVisible());
        } else if (object instanceof ResultSetTable && string2.equals("showNumber")) {
            this.itemToCompMap.get((Object)Item.showColumnNumber).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof DatabaseInfoTree) {
            this.itemToCompMap.get((Object)Item.showInfoTree).setSelected(((Component)object).isEnabled());
        } else if (object instanceof JFrame && string2.equals("alwaysOnTop")) {
            this.itemToCompMap.get((Object)Item.showAlwaysOnTop).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof ResultSetTable && string2.equals("autoAdjustMode")) {
            String string3 = propertyChangeEvent.getNewValue().toString();
            if (!string3.matches("[A-Z_]+")) {
                this.itemToCompMap.get((Object)Item.of(string3)).setSelected(true);
            }
        } else if (object instanceof WindowOutputProcessor && string2.equals("postProcessMode") && !(string = propertyChangeEvent.getNewValue().toString()).matches("[A-Z_]+")) {
            this.itemToCompMap.get((Object)Item.of(string)).setSelected(true);
        }
    }

    void setEnabledStates(boolean bl) {
        boolean bl2 = !bl;
        for (JMenuItem object : this.lockingTargets) {
            object.setEnabled(bl2);
        }
        boolean bl3 = bl;
        for (JMenuItem jMenuItem : this.unlockingTargets) {
            jMenuItem.setEnabled(bl3);
        }
    }

    private static JMenu createJMenu(ResourceManager resourceManager, String string) {
        String string2 = (resourceManager.containsKey("group." + string) ? "group" : "item") + '.' + string;
        char c = resourceManager.getChar(string2 + ".mnemonic");
        boolean bl = resourceManager.getInt("auto-mnemonic") == 1;
        String string3 = resourceManager.get(string2, new Object[0]) + (bl ? "(" + c + ")" : "");
        JMenu jMenu = new JMenu(string3);
        jMenu.setMnemonic(c);
        return jMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshAllAccelerators(Map<String, JMenuItem> map) {
        String string;
        File file = Bootstrap.getSystemFile("keybind.conf");
        if (!file.exists()) {
            return;
        }
        HashMap<String, KeyStroke> hashMap = new HashMap<String, KeyStroke>();
        try {
            Iterator<String> iterator = new Scanner(file);
            try {
                Pattern object = Pattern.compile("\\s*([^=\\s]+)\\s*=(.*)");
                while (((Scanner)iterator).hasNextLine()) {
                    Matcher matcher;
                    string = ((Scanner)iterator).nextLine();
                    if (string.trim().length() == 0 || string.matches("\\s*#.*") || !(matcher = object.matcher(string)).matches()) continue;
                    hashMap.put(matcher.group(1), Utilities.getKeyStroke(matcher.group(2)));
                }
            }
            finally {
                ((Scanner)iterator).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            if (!map.containsKey(string)) continue;
            map.get(string).setAccelerator((KeyStroke)entry.getValue());
        }
    }

    static List<JMenuItem> createJMenuItems(ResourceManager resourceManager, String string) {
        HashMap<String, JMenuItem> hashMap = new HashMap<String, JMenuItem>();
        List<JMenuItem> list = Menu.createJMenuItems(resourceManager, hashMap, string);
        Menu.refreshAllAccelerators(hashMap);
        return list;
    }

    static List<JMenuItem> createJMenuItems(ResourceManager resourceManager, Map<String, JMenuItem> map, String string) {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        for (String string2 : resourceManager.get(string + ".items", new Object[0]).split(",", -1)) {
            if (string2.length() == 0) {
                arrayList.add(null);
                continue;
            }
            JMenuItem jMenuItem = Menu.createJMenuItem(resourceManager, string2);
            arrayList.add(jMenuItem);
            map.put(string2, jMenuItem);
        }
        return arrayList;
    }

    static JMenuItem createJMenuItem(ResourceManager resourceManager, String string) {
        Serializable serializable;
        JMenuItem jMenuItem;
        boolean bl = resourceManager.getInt("auto-mnemonic") == 1;
        String string2 = "item." + string;
        char c = resourceManager.getChar(string2 + ".mnemonic");
        String string3 = string2 + ".shortcut";
        if (resourceManager.isTrue(string2 + ".checkbox")) {
            jMenuItem = new JCheckBoxMenuItem();
        } else if (resourceManager.isTrue(string2 + ".subgroup")) {
            jMenuItem = Menu.createJMenu(resourceManager, string);
            serializable = new ButtonGroup();
            boolean bl2 = false;
            for (String string4 : resourceManager.get(string2 + ".items", new Object[0]).split(",", -1)) {
                JMenuItem jMenuItem2 = Menu.createJMenuItem(resourceManager, string + string4);
                jMenuItem.add(jMenuItem2);
                ((ButtonGroup)serializable).add(jMenuItem2);
                if (bl2) continue;
                jMenuItem2.setSelected(true);
                bl2 = true;
            }
        } else {
            jMenuItem = new JMenuItem();
        }
        if (resourceManager.containsKey(string3) && (serializable = Utilities.getKeyStroke(resourceManager.get(string3, new Object[0]))) != null) {
            jMenuItem.setAccelerator((KeyStroke)serializable);
        }
        jMenuItem.setText(resourceManager.get(string2, new Object[0]) + (bl ? "(" + c + ")" : ""));
        jMenuItem.setMnemonic(c);
        jMenuItem.setActionCommand(string);
        jMenuItem.setIcon(Utilities.getImageIcon(String.format("menu-%s.png", string)));
        jMenuItem.setDisabledIcon(Utilities.getImageIcon(String.format("menu-disabled-%s.png", string)));
        return jMenuItem;
    }

    static enum Item {
        newWindow,
        closeWindow,
        quit,
        cut,
        copy,
        paste,
        selectAll,
        find,
        toggleFocus,
        clearMessage,
        showStatusBar,
        showColumnNumber,
        showInfoTree,
        showAlwaysOnTop,
        refresh,
        widenColumnWidth,
        narrowColumnWidth,
        adjustColumnWidth,
        autoAdjustMode,
        autoAdjustModeNone,
        autoAdjustModeHeader,
        autoAdjustModeValue,
        autoAdjustModeHeaderAndValue,
        executeCommand,
        breakCommand,
        lastHistory,
        nextHistory,
        sendRollback,
        sendCommit,
        connect,
        disconnect,
        postProcessMode,
        postProcessModeNone,
        postProcessModeFocus,
        postProcessModeShake,
        postProcessModeBlink,
        inputEcryptionKey,
        editConnectors,
        sortResult,
        importFile,
        exportFile,
        showHelp,
        showAbout,
        unknown;


        static Item of(String string) {
            try {
                return Item.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return unknown;
            }
        }
    }
}

