/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Logger;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;
import net.argius.stew.io.Importer;
import net.argius.stew.text.TextUtilities;

public class Load
extends Command {
    private static final Logger log = Logger.getLogger(Load.class);

    @Override
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (!parameter.has(1)) {
            throw new UsageException(this.getUsage());
        }
        try {
            File file = this.resolvePath(parameter.at(1));
            if (log.isDebugEnabled()) {
                log.debug("file: " + file.getAbsolutePath());
            }
            if (parameter.has(2)) {
                String string = parameter.at(2);
                boolean bl = parameter.at(3).equalsIgnoreCase("HEADER");
                if (log.isDebugEnabled()) {
                    log.debug("table: " + string);
                    log.debug("hasHeader: " + bl);
                }
                this.loadRecord(connection, file, string, bl);
            } else {
                this.loadSql(connection, file);
            }
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSql(Connection connection, File file) throws IOException, SQLException {
        block8: {
            String string = Load.readFileAsString(file);
            if (log.isDebugEnabled()) {
                log.debug("sql : " + string);
            }
            Statement statement = this.prepareStatement(connection, string);
            try {
                if (Load.isSelect(string)) {
                    ResultSet resultSet = this.executeQuery(statement, string);
                    try {
                        ResultSetReference resultSetReference = new ResultSetReference(resultSet, string);
                        this.output(resultSetReference);
                        this.outputMessage("i.selected", resultSetReference.getRecordCount());
                        break block8;
                    }
                    finally {
                        resultSet.close();
                    }
                }
                int n = statement.executeUpdate(string);
                this.outputMessage("i.proceeded", n);
            }
            finally {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRecord(Connection connection, File file, String string, boolean bl) throws IOException, SQLException {
        Importer importer = Importer.getImporter(file);
        try {
            Object object;
            Object object2;
            Object[] objectArray;
            if (bl) {
                objectArray = importer.nextRow();
            } else {
                object2 = Importer.getImporter(file);
                try {
                    object = ((Importer)object2).nextRow();
                    Arrays.fill(object, "");
                    objectArray = object;
                }
                finally {
                    ((Importer)object2).close();
                }
            }
            object2 = Arrays.asList(objectArray);
            object = bl ? String.format("(%s)", TextUtilities.join(",", object2)) : "";
            ArrayList arrayList = new ArrayList(object2);
            Collections.fill(arrayList, "?");
            String string2 = String.format("INSERT INTO %s %s VALUES (%s)", string, object, TextUtilities.join(",", arrayList));
            if (log.isDebugEnabled()) {
                log.debug("SQL : " + string2);
            }
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            try {
                this.insertRecords(preparedStatement, importer);
            }
            finally {
                preparedStatement.close();
            }
        }
        finally {
            importer.close();
        }
    }

    protected void insertRecords(PreparedStatement preparedStatement, Importer importer) throws IOException, SQLException {
        Object[] objectArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((objectArray = importer.nextRow()) != null && objectArray.length != 0) {
            ++n;
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    int n4 = i + 1;
                    Object object = objectArray[i];
                    preparedStatement.setObject(n4, object);
                }
                n2 += preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                String string = "error occurred at " + n;
                if (log.isTraceEnabled()) {
                    log.trace(string, (Object)sQLException);
                } else if (log.isDebugEnabled()) {
                    log.debug(string + " : " + sQLException);
                }
                ++n3;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("record   = " + n);
            log.debug("inserted = " + n2);
            log.debug("error    = " + n3);
        }
        this.outputMessage("i.loaded", n2, n);
    }
}

