/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.format.xml;

import java.io.PrintWriter;
import java.util.Iterator;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.format.AbstractBirthmarkExtractionResultFormat;

public class BirthmarkExtractionListXmlFormat
extends AbstractBirthmarkExtractionResultFormat {
    public void printResult(PrintWriter out, BirthmarkSet[] holders) {
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<birthmark>");
        out.println("  <extracted-birthmarks>");
        for (int i = 0; i < holders.length; ++i) {
            this.printBirthmarkHolder(out, holders[i]);
        }
        out.println("  </extracted-birthmarks>");
        out.println("</birthmark>");
    }

    protected void printBirthmarkHolder(PrintWriter out, BirthmarkSet holder) {
        out.println("    <extracted-birthmark>");
        out.print("      <class-name>");
        out.print(this.escapeToXmlString(holder.getClassName()));
        out.println("</class-name>");
        out.print("      <location>");
        out.print(this.escapeToXmlString(holder.getLocation()));
        out.println("</location>");
        Iterator<String> i = holder.birthmarkTypes();
        while (i.hasNext()) {
            String type = i.next();
            Birthmark birthmark = holder.getBirthmark(type);
            out.print("      <birthmark type=\"");
            out.print(birthmark.getType());
            out.print("\" count=\"");
            out.print(birthmark.getElementCount());
            out.println("\">");
            Iterator<BirthmarkElement> elements = birthmark.iterator();
            while (elements.hasNext()) {
                out.print("        <element>");
                out.print(this.escapeToXmlString(elements.next().toString()));
                out.println("</element>");
            }
            out.println("      </birthmark>");
        }
        out.println("    </extracted-birthmark>");
    }

    public String escapeToXmlString(Object o) {
        if (o != null) {
            return this.escapeToXmlString(o.toString());
        }
        return null;
    }

    public String escapeToXmlString(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }
}

