/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.filter;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.filter.Target;
import jp.naist.se.stigmata.filter.TargetNameComparisonPairFilter;
import jp.naist.se.stigmata.filter.TargetNameComparisonPairFilterService;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.filter.AbstractComparisonPairFilterComponentService;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class TargetNameComparisonPairFilterComponentService
extends AbstractComparisonPairFilterComponentService {
    public ComparisonPairFilterPane createComponent(ComparisonPairFilterSpi service) {
        return new Pane(service);
    }

    public String getFilterName() {
        return "name";
    }

    public ComparisonPairFilterSpi getComparisonPairFilterService() {
        return new TargetNameComparisonPairFilterService();
    }

    private static class Pane
    extends ComparisonPairFilterPane {
        private static final long serialVersionUID = 8912037614500713027L;
        private ComparisonPairFilterSpi service;
        private JComboBox criterionType;
        private JTextField value;
        private JComboBox targetType;

        public Pane(ComparisonPairFilterSpi service) {
            this.service = service;
            this.initLayouts();
        }

        public String[] getErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.value.getText().trim().equals("")) {
                errors.add(Messages.getString("error.empty.value"));
            }
            return errors.toArray(new String[errors.size()]);
        }

        public ComparisonPairFilter getFilter() {
            try {
                TargetNameComparisonPairFilter filter = new TargetNameComparisonPairFilter(this.service);
                filter.setCriterion(this.getCriterion((String)this.criterionType.getSelectedItem()));
                filter.setValue(this.value.getText());
                filter.setTarget(this.getTarget((String)this.targetType.getSelectedItem()));
                return filter;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void resetComponents() {
            this.value.setText("");
            this.criterionType.setSelectedIndex(0);
            this.targetType.setSelectedItem(this.getDisplayTarget(Target.BOTH_TARGET));
        }

        public void setFilter(ComparisonPairFilter cpf) {
            TargetNameComparisonPairFilter filter = (TargetNameComparisonPairFilter)cpf;
            this.criterionType.setSelectedItem(this.getDisplayCriterion(filter.getCriterion()));
            this.value.setText(filter.getValue());
            this.targetType.setSelectedItem(this.getDisplayTarget(filter.getTarget()));
        }

        private void initLayouts() {
            JLabel label = new JLabel(Messages.getString("filter.name.label"));
            this.value = new JTextField();
            this.criterionType = this.createCriteriaBox(TargetNameComparisonPairFilter.CRITERIA);
            this.targetType = this.createTargetBox();
            this.setLayout(new GridLayout(4, 1));
            this.add(label);
            this.add(this.targetType);
            this.add(this.criterionType);
            this.add(this.value);
        }
    }
}

