/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.core.history.LocalFileHistory;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.CompareRevisionAction;
import org.eclipse.team.internal.ui.actions.OpenRevisionAction;
import org.eclipse.team.internal.ui.actions.OpenWithMenu;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.DateHistoryCategory;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.LocalHistoryPageSource;
import org.eclipse.team.internal.ui.history.LocalHistoryTableProvider;
import org.eclipse.team.internal.ui.history.MessageHistoryCategory;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryCompareAdapter;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.IProgressConstants;

public class LocalHistoryPage
extends HistoryPage
implements IHistoryCompareAdapter {
    public static final int ON = 1;
    public static final int OFF = 2;
    public static final int ALWAYS = 4;
    IFile file;
    IFileRevision currentFileRevision;
    LocalFileHistory localFileHistory;
    TreeViewer treeViewer;
    boolean shutdown = false;
    private boolean groupingOn = true;
    private int compareMode = 2;
    protected LocalFileHistoryTableProvider historyTableProvider;
    private RefreshFileHistory refreshFileHistoryJob;
    private Composite localComposite;
    private Action groupByDateMode;
    private Action collapseAll;
    private Action compareModeAction;
    private Action getContentsAction;
    private CompareRevisionAction compareAction;
    private OpenRevisionAction openAction;
    private OpenWithMenu openWithMenu;
    private HistoryResourceListener resourceListener;
    private IFileRevision currentSelection;

    public LocalHistoryPage(int compareMode) {
        this.compareMode = compareMode;
    }

    public LocalHistoryPage() {
    }

    @Override
    public boolean inputSet() {
        IFile tempFile;
        this.currentFileRevision = null;
        this.file = tempFile = this.getFile();
        if (tempFile == null) {
            return false;
        }
        this.treeViewer.setInput(null);
        this.localFileHistory = new LocalFileHistory(this.file, !this.getHistoryPageSite().isModal());
        if (this.refreshFileHistoryJob == null) {
            this.refreshFileHistoryJob = new RefreshFileHistory();
        }
        this.refreshHistory(true);
        return true;
    }

    protected IFile getFile() {
        return LocalHistoryPageSource.getFile(this.getInput());
    }

    private void refreshHistory(boolean refetch) {
        if (Policy.DEBUG_HISTORY) {
            String time = new SimpleDateFormat("m:ss.SSS").format(new Date(System.currentTimeMillis()));
            System.out.println(String.valueOf(time) + ": LocalHistoryPage#refreshHistory, refetch = " + refetch);
        }
        if (this.refreshFileHistoryJob.getState() != 0) {
            this.refreshFileHistoryJob.cancel();
        }
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        Utils.schedule(this.refreshFileHistoryJob, (IWorkbenchSite)this.getWorkbenchSite(parentSite));
    }

    private IWorkbenchPartSite getWorkbenchSite(IHistoryPageSite parentSite) {
        IWorkbenchPart part = parentSite.getPart();
        if (part != null) {
            return part.getSite();
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.localComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.localComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.localComposite.setLayoutData((Object)data);
        this.treeViewer = this.createTree(this.localComposite);
        this.contributeActions();
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (parentSite != null && parentSite instanceof DialogHistoryPageSite && this.treeViewer != null) {
            parentSite.setSelectionProvider((ISelectionProvider)this.treeViewer);
        }
        this.resourceListener = new HistoryResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.localComposite, "org.eclipse.team.ui.local_history_context");
    }

    private void contributeActions() {
        IToolBarManager tbm;
        final IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        this.groupByDateMode = new Action(TeamUIMessages.LocalHistoryPage_GroupRevisionsByDateAction, TeamUIPlugin.getImageDescriptor("obj/dates.png")){

            public void run() {
                LocalHistoryPage.this.groupingOn = !LocalHistoryPage.this.groupingOn;
                store.setValue("org.eclipse.team.ui.group_bydate_mode", LocalHistoryPage.this.groupingOn);
                LocalHistoryPage.this.refreshHistory(false);
            }
        };
        this.groupingOn = store.getBoolean("org.eclipse.team.ui.group_bydate_mode");
        this.groupByDateMode.setChecked(this.groupingOn);
        this.groupByDateMode.setToolTipText(TeamUIMessages.LocalHistoryPage_GroupRevisionsByDateTip);
        this.groupByDateMode.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("obj/dates.png"));
        this.groupByDateMode.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("obj/dates.png"));
        this.collapseAll = new Action(TeamUIMessages.LocalHistoryPage_CollapseAllAction, TeamUIPlugin.getImageDescriptor("elcl16/collapseall.png")){

            public void run() {
                LocalHistoryPage.this.treeViewer.collapseAll();
            }
        };
        this.collapseAll.setToolTipText(TeamUIMessages.LocalHistoryPage_CollapseAllTip);
        this.collapseAll.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("elcl16/collapseall.png"));
        this.collapseAll.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("elcl16/collapseall.png"));
        IHistoryPageSite historyPageSite = this.getHistoryPageSite();
        if (!historyPageSite.isModal()) {
            IPageSite pageSite;
            if ((this.compareMode & 4) == 0) {
                this.compareModeAction = new Action(TeamUIMessages.LocalHistoryPage_CompareModeAction, TeamUIPlugin.getImageDescriptor("eview16/compare_view.png")){

                    public void run() {
                        LocalHistoryPage.this.compareMode = LocalHistoryPage.this.compareMode == 1 ? 2 : 1;
                        LocalHistoryPage.this.compareModeAction.setChecked(LocalHistoryPage.this.compareMode == 1);
                    }
                };
                this.compareModeAction.setToolTipText(TeamUIMessages.LocalHistoryPage_CompareModeTip);
                this.compareModeAction.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("eview16/compare_view.png"));
                this.compareModeAction.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("eview16/compare_view.png"));
                this.compareModeAction.setChecked(this.compareMode == 1);
                this.getContentsAction = this.getContextMenuAction(TeamUIMessages.LocalHistoryPage_GetContents, true, monitor -> {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                    try {
                        try {
                            if (this.confirmOverwrite()) {
                                IStorage currentStorage = this.currentSelection.getStorage((IProgressMonitor)progress.split(1));
                                InputStream in = currentStorage.getContents();
                                this.file.setContents(in, false, true, (IProgressMonitor)progress.split(1));
                            }
                        }
                        catch (TeamException e) {
                            throw new CoreException(e.getStatus());
                        }
                    }
                    finally {
                        monitor.done();
                    }
                });
            }
            this.compareAction = this.createCompareAction();
            this.compareAction.setEnabled(!this.treeViewer.getSelection().isEmpty());
            this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalHistoryPage.this.compareAction.setCurrentFileRevision(LocalHistoryPage.this.getCurrentFileRevision());
                    LocalHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)LocalHistoryPage.this.treeViewer.getStructuredSelection());
                }
            });
            if ((this.compareMode & 5) != 5) {
                this.openAction = new OpenRevisionAction(TeamUIMessages.LocalHistoryPage_OpenAction, this);
                this.openAction.setEnabled(!this.treeViewer.getSelection().isEmpty());
                this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LocalHistoryPage.this.openAction.selectionChanged((IStructuredSelection)LocalHistoryPage.this.treeViewer.getStructuredSelection());
                    }
                });
                this.openWithMenu = new OpenWithMenu(this);
                this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LocalHistoryPage.this.openWithMenu.selectionChanged((IStructuredSelection)LocalHistoryPage.this.treeViewer.getStructuredSelection());
                    }
                });
            }
            new OpenAndLinkWithEditorHelper((StructuredViewer)this.treeViewer){

                protected void open(ISelection selection, boolean activate) {
                    if (LocalHistoryPage.this.getSite() != null && selection instanceof IStructuredSelection) {
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        if ((LocalHistoryPage.this.compareMode & 1) > 0) {
                            StructuredSelection sel = new StructuredSelection(new Object[]{LocalHistoryPage.this.getCurrentFileRevision(), structuredSelection.getFirstElement()});
                            LocalHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)sel);
                            LocalHistoryPage.this.compareAction.run();
                        } else if (LocalHistoryPage.this.openAction != null) {
                            LocalHistoryPage.this.openAction.selectionChanged(structuredSelection);
                            LocalHistoryPage.this.openAction.run();
                        }
                    }
                }

                protected void activate(ISelection selection) {
                    int currentMode = OpenStrategy.getOpenMethod();
                    try {
                        OpenStrategy.setOpenMethod((int)0);
                        this.open(selection, true);
                    }
                    finally {
                        OpenStrategy.setOpenMethod((int)currentMode);
                    }
                }

                protected void linkToEditor(ISelection selection) {
                }
            };
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
            menuMgr.addMenuListener(menuMgr1 -> this.fillTableMenu(menuMgr1));
            menuMgr.setRemoveAllWhenShown(true);
            this.treeViewer.getTree().setMenu(menu);
            IWorkbenchPart part = historyPageSite.getPart();
            if (part != null) {
                IWorkbenchPartSite workbenchPartSite = part.getSite();
                workbenchPartSite.registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
            }
            if ((pageSite = historyPageSite.getWorkbenchPageSite()) != null) {
                IActionBars actionBars = pageSite.getActionBars();
                IMenuManager actionBarsMenu = actionBars.getMenuManager();
                if (actionBarsMenu != null) {
                    actionBarsMenu.removeAll();
                }
                actionBars.updateActionBars();
            }
        }
        if ((tbm = historyPageSite.getToolBarManager()) != null) {
            String fileNameQualifier = this.getFileNameQualifier();
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "grouping"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "grouping", (IAction)this.groupByDateMode);
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "collapse"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "collapse", (IAction)this.collapseAll);
            if (this.compareModeAction != null) {
                tbm.appendToGroup(String.valueOf(fileNameQualifier) + "collapse", (IAction)this.compareModeAction);
            }
            tbm.update(false);
        }
    }

    protected CompareRevisionAction createCompareAction() {
        return new CompareRevisionAction(this);
    }

    private String getFileNameQualifier() {
        if (this.file != null) {
            return this.file.getFullPath().toString();
        }
        return "";
    }

    protected void fillTableMenu(IMenuManager manager) {
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        manager.add((IContributionItem)new Separator("additions"));
        if (this.file != null && !parentSite.isModal()) {
            IStructuredSelection tempSelection;
            ISelection sel;
            if (this.openAction != null) {
                manager.add((IAction)this.openAction);
            }
            if (this.openWithMenu != null) {
                MenuManager openWithSubmenu = new MenuManager(TeamUIMessages.LocalHistoryPage_OpenWithMenu);
                openWithSubmenu.add((IContributionItem)this.openWithMenu);
                manager.add((IContributionItem)openWithSubmenu);
            }
            if (this.compareAction != null) {
                manager.add((IAction)this.compareAction);
            }
            if (this.getContentsAction != null && !(sel = this.treeViewer.getSelection()).isEmpty() && sel instanceof IStructuredSelection && (tempSelection = (IStructuredSelection)sel).size() == 1) {
                manager.add((IContributionItem)new Separator("getContents"));
                manager.add((IAction)this.getContentsAction);
            }
        }
    }

    protected TreeViewer createTree(Composite parent) {
        this.historyTableProvider = new LocalFileHistoryTableProvider();
        TreeViewer viewer = this.historyTableProvider.createTree(parent);
        viewer.setContentProvider((IContentProvider)new LocalHistoryContentProvider());
        return viewer;
    }

    public Control getControl() {
        return this.localComposite;
    }

    public void setFocus() {
        this.localComposite.setFocus();
    }

    @Override
    public String getDescription() {
        if (this.getFile() != null) {
            return this.getFile().getFullPath().toString();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.getFile() != null) {
            return this.getFile().getName();
        }
        return "";
    }

    @Override
    public boolean isValidInput(Object object) {
        return object instanceof IFile;
    }

    @Override
    public void refresh() {
        this.refreshHistory(true);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IHistoryCompareAdapter.class) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.shutdown = true;
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.resourceListener = null;
        }
        if (this.refreshFileHistoryJob != null && this.refreshFileHistoryJob.getState() != 0) {
            this.refreshFileHistoryJob.cancel();
        }
    }

    public IFileRevision getCurrentFileRevision() {
        if (this.currentFileRevision != null) {
            return this.currentFileRevision;
        }
        if (this.file != null) {
            this.currentFileRevision = new LocalFileRevision(this.file);
        }
        return this.currentFileRevision;
    }

    private Action getContextMenuAction(String title, final boolean needsProgressDialog, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                block9: {
                    try {
                        if (LocalHistoryPage.this.file == null) {
                            return;
                        }
                        ISelection selection = LocalHistoryPage.this.treeViewer.getSelection();
                        if (!(selection instanceof IStructuredSelection)) {
                            return;
                        }
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        Object o = ss.getFirstElement();
                        if (o instanceof AbstractHistoryCategory) {
                            return;
                        }
                        LocalHistoryPage.this.currentSelection = (IFileRevision)o;
                        if (needsProgressDialog) {
                            PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> {
                                try {
                                    action.run(monitor);
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            });
                            break block9;
                        }
                        try {
                            action.run(null);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (InvocationTargetException e) {
                        IHistoryPageSite parentSite = LocalHistoryPage.this.getHistoryPageSite();
                        Utils.handleError(parentSite.getShell(), e, null, null);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public boolean isEnabled() {
                ISelection selection = LocalHistoryPage.this.treeViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        if (this.file != null && this.file.exists()) {
            String title = TeamUIMessages.LocalHistoryPage_OverwriteTitle;
            String msg = TeamUIMessages.LocalHistoryPage_OverwriteMessage;
            IHistoryPageSite parentSite = this.getHistoryPageSite();
            MessageDialog dialog = new MessageDialog(parentSite.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            int[] result = new int[1];
            parentSite.getShell().getDisplay().syncExec(() -> {
                int n = dialog.open();
            });
            if (result[0] != 0) {
                return false;
            }
        }
        return true;
    }

    public void setClickAction(boolean compare) {
        int n = this.compareMode = compare ? 1 : 2;
        if (this.compareModeAction != null) {
            this.compareModeAction.setChecked(this.compareMode == 1);
        }
    }

    @Override
    public ICompareInput getCompareInput(Object object) {
        if (object instanceof IFileRevision) {
            IFileRevision selectedFileRevision = (IFileRevision)object;
            ITypedElement fileElement = SaveableCompareEditorInput.createFileElement(this.file);
            FileRevisionTypedElement right = new FileRevisionTypedElement(selectedFileRevision);
            DiffNode node = new DiffNode(fileElement, (ITypedElement)right);
            return node;
        }
        return null;
    }

    @Override
    public void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) {
        ITypedElement left;
        ITypedElement right = input.getRight();
        if (right != null) {
            Image image;
            String label = this.getLabel(right);
            if (label != null) {
                configuration.setRightLabel(label);
            }
            if ((image = this.getImage(right)) != null) {
                configuration.setRightImage(image);
            }
        }
        if ((left = input.getLeft()) != null) {
            Image image;
            String label = this.getLabel(left);
            if (label != null) {
                configuration.setLeftLabel(label);
            }
            if ((image = this.getImage(left)) != null) {
                configuration.setLeftImage(image);
            }
        }
    }

    protected Image getImage(Object right) {
        if (right instanceof FileRevisionTypedElement || right instanceof LocalFileRevision || right instanceof IFileRevision) {
            return this.historyTableProvider.getRevisionImage();
        }
        if (right instanceof ITypedElement) {
            ITypedElement te = (ITypedElement)right;
            return te.getImage();
        }
        return null;
    }

    protected String getLabel(Object object) {
        IFileRevision revision;
        long timestamp;
        if (object instanceof IFileRevision && (timestamp = (revision = (IFileRevision)object).getTimestamp()) > 0L) {
            return NLS.bind((String)TeamUIMessages.LocalHistoryPage_0, (Object)this.historyTableProvider.getDateFormat().format(new Date(timestamp)));
        }
        if (object instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement e = (FileRevisionTypedElement)object;
            return this.getLabel(e.getRevision());
        }
        if (object instanceof LocalResourceTypedElement) {
            return TeamUIMessages.LocalHistoryPage_1;
        }
        return null;
    }

    protected void update(IFileRevision[] revisions, IProgressMonitor monitor) {
        AbstractHistoryCategory[] categories = this.groupRevisions(revisions, monitor);
        Utils.asyncExec(() -> {
            if (Policy.DEBUG_HISTORY) {
                String time = new SimpleDateFormat("m:ss.SSS").format(new Date(System.currentTimeMillis()));
                System.out.println(String.valueOf(time) + ": LocalHistoryPage#update, the tree is being updated in the UI thread");
            }
            if (categories != null) {
                Object[] elementsToExpand = this.mapExpandedElements(categories, this.treeViewer.getExpandedElements());
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.setInput((Object)categories);
                if (elementsToExpand.length > 0) {
                    this.treeViewer.setExpandedElements(elementsToExpand);
                } else {
                    this.treeViewer.expandAll();
                    Object[] el = this.treeViewer.getExpandedElements();
                    if (el != null && el.length > 0) {
                        this.treeViewer.setSelection((ISelection)new StructuredSelection(el[0]));
                        this.treeViewer.getTree().deselectAll();
                    }
                }
                this.treeViewer.getTree().setRedraw(true);
            } else if (revisions.length > 0) {
                this.treeViewer.setInput((Object)revisions);
            } else {
                this.treeViewer.setInput((Object)new AbstractHistoryCategory[]{this.getErrorMessage()});
            }
        }, (StructuredViewer)this.treeViewer);
    }

    private AbstractHistoryCategory[] groupRevisions(IFileRevision[] revisions, IProgressMonitor monitor) {
        if (this.groupingOn) {
            return this.sortRevisions(revisions, monitor);
        }
        return null;
    }

    private Object[] mapExpandedElements(AbstractHistoryCategory[] categories, Object[] expandedElements) {
        HashSet<String> names = new HashSet<String>();
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object expandedElement = objectArray[n2];
            names.add(((DateHistoryCategory)expandedElement).getName());
            ++n2;
        }
        ArrayList<AbstractHistoryCategory> expandable = new ArrayList<AbstractHistoryCategory>();
        AbstractHistoryCategory[] abstractHistoryCategoryArray = categories;
        int n3 = categories.length;
        n = 0;
        while (n < n3) {
            AbstractHistoryCategory category = abstractHistoryCategoryArray[n];
            if (names.contains(category.getName())) {
                expandable.add(category);
            }
            ++n;
        }
        return expandable.toArray(new Object[expandable.size()]);
    }

    private AbstractHistoryCategory[] sortRevisions(IFileRevision[] revisions, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 100);
            DateHistoryCategory[] tempCategories = new DateHistoryCategory[4];
            Calendar currentCal = Calendar.getInstance();
            tempCategories[0] = new DateHistoryCategory(TeamUIMessages.HistoryPage_Today, currentCal, null);
            Calendar yesterdayCal = Calendar.getInstance();
            yesterdayCal.roll(6, -1);
            tempCategories[1] = new DateHistoryCategory(TeamUIMessages.HistoryPage_Yesterday, yesterdayCal, null);
            Calendar monthCal = Calendar.getInstance();
            monthCal.set(5, 1);
            tempCategories[2] = new DateHistoryCategory(TeamUIMessages.HistoryPage_ThisMonth, monthCal, yesterdayCal);
            tempCategories[3] = new DateHistoryCategory(TeamUIMessages.HistoryPage_Previous, null, monthCal);
            ArrayList<AbstractHistoryCategory> finalCategories = new ArrayList<AbstractHistoryCategory>();
            DateHistoryCategory[] dateHistoryCategoryArray = tempCategories;
            int n = tempCategories.length;
            int n2 = 0;
            while (n2 < n) {
                DateHistoryCategory tempCategory = dateHistoryCategoryArray[n2];
                tempCategory.collectFileRevisions(revisions, false);
                if (tempCategory.hasRevisions()) {
                    finalCategories.add(tempCategory);
                }
                ++n2;
            }
            if (finalCategories.isEmpty()) {
                finalCategories.add(this.getErrorMessage());
            }
            AbstractHistoryCategory[] abstractHistoryCategoryArray = finalCategories.toArray(new AbstractHistoryCategory[finalCategories.size()]);
            return abstractHistoryCategoryArray;
        }
        finally {
            monitor.done();
        }
    }

    private MessageHistoryCategory getErrorMessage() {
        MessageHistoryCategory messageCategory = new MessageHistoryCategory(this.getNoChangesMessage());
        return messageCategory;
    }

    protected String getNoChangesMessage() {
        return TeamUIMessages.LocalHistoryPage_NoRevisionsFound;
    }

    private class HistoryResourceListener
    implements IResourceChangeListener {
        private HistoryResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            if (LocalHistoryPage.this.file == null) {
                return;
            }
            IResourceDelta resourceDelta = root.findMember(LocalHistoryPage.this.file.getFullPath());
            if (resourceDelta != null) {
                Display.getDefault().asyncExec(() -> LocalHistoryPage.this.refresh());
            }
        }
    }

    private class LocalFileHistoryTableProvider
    extends LocalHistoryTableProvider {
        private LocalFileHistoryTableProvider() {
        }

        protected IFileRevision adaptToFileRevision(Object element) {
            IFileRevision[] revisions;
            IFileRevision entry = null;
            if (element instanceof IFileRevision) {
                entry = (IFileRevision)element;
            } else if (element instanceof IAdaptable) {
                entry = (IFileRevision)((IAdaptable)element).getAdapter(IFileRevision.class);
            } else if (element instanceof AbstractHistoryCategory && (revisions = ((AbstractHistoryCategory)element).getRevisions()).length > 0) {
                entry = revisions[0];
            }
            return entry;
        }

        private long getCurrentRevision() {
            if (LocalHistoryPage.this.file != null) {
                return LocalHistoryPage.this.file.getLocalTimeStamp();
            }
            return -1L;
        }

        @Override
        protected long getModificationDate(Object element) {
            IFileRevision entry = this.adaptToFileRevision(element);
            if (entry != null) {
                return entry.getTimestamp();
            }
            return -1L;
        }

        @Override
        protected boolean isCurrentEdition(Object element) {
            IFileRevision entry = this.adaptToFileRevision(element);
            if (entry == null) {
                return false;
            }
            long timestamp = entry.getTimestamp();
            long tempCurrentTimeStamp = this.getCurrentRevision();
            return tempCurrentTimeStamp != -1L && tempCurrentTimeStamp == timestamp;
        }

        @Override
        protected boolean isDeletedEdition(Object element) {
            IFileRevision entry = this.adaptToFileRevision(element);
            return !entry.exists();
        }
    }

    private final class LocalHistoryContentProvider
    implements ITreeContentProvider {
        private LocalHistoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IFileHistory) {
                IFileHistory fileHistory = (IFileHistory)inputElement;
                return fileHistory.getFileRevisions();
            }
            if (inputElement instanceof IFileRevision[]) {
                return (IFileRevision[])inputElement;
            }
            if (inputElement instanceof AbstractHistoryCategory[]) {
                return (AbstractHistoryCategory[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AbstractHistoryCategory) {
                return ((AbstractHistoryCategory)parentElement).getRevisions();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof AbstractHistoryCategory) {
                return ((AbstractHistoryCategory)element).hasRevisions();
            }
            return false;
        }
    }

    private class RefreshFileHistory
    extends Job {
        public RefreshFileHistory() {
            super(TeamUIMessages.LocalHistoryPage_FetchLocalHistoryMessage);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IStatus status = Status.OK_STATUS;
                LocalFileHistory fileHistory = LocalHistoryPage.this.localFileHistory;
                if (fileHistory == null || LocalHistoryPage.this.shutdown) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                try {
                    fileHistory.refresh(Policy.subMonitorFor(monitor, 50));
                }
                catch (CoreException ex) {
                    status = new TeamStatus(ex.getStatus().getSeverity(), "org.eclipse.team.ui", ex.getStatus().getCode(), ex.getMessage(), (Throwable)ex, (IResource)LocalHistoryPage.this.file);
                }
                LocalHistoryPage.this.update(fileHistory.getFileRevisions(), Policy.subMonitorFor(monitor, 50));
                if (status != Status.OK_STATUS) {
                    this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                    this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                }
                if (Policy.DEBUG_HISTORY) {
                    String time = new SimpleDateFormat("m:ss.SSS").format(new Date(System.currentTimeMillis()));
                    System.out.println(String.valueOf(time) + ": RefreshFileHistoryJob#run finished, status: " + status);
                }
                IStatus iStatus = status;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

