/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.gtx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sf.tatooine.gtx.LoopRangeSyntaxException;

public class LoopRange {
    public static final Pattern PTN_N = Pattern.compile("^([1-9][0-9]*|0)$");
    public static final Pattern PTN_S2E1 = Pattern.compile("^([1-9][0-9]*|0)\\.\\.([1-9][0-9]*|0)$");
    public static final Pattern PTN_S2E2 = Pattern.compile("^([1-9][0-9]*|0)\\.\\.\\.([1-9][0-9]*|0)$");
    public static final Pattern PTN_A_LEN = Pattern.compile("^([1-9][0-9]*|0)\\s*,\\s*([1-9][0-9]*|0)$");
    private int _begin = 0;
    private int _end = 0;
    private int _step = 1;

    public LoopRange(int begin, int end) {
        this._begin = begin;
        this._end = end;
    }

    public LoopRange(int begin, int end, int step) {
        this._begin = begin;
        this._end = end;
        this._step = step;
    }

    public final int getBegin() {
        return this._begin;
    }

    public final void setBegin(int begin) {
        this._begin = begin;
    }

    public final int getEnd() {
        return this._end;
    }

    public final void setEnd(int end) {
        this._end = end;
    }

    public final void setStep(int step) {
        this._step = step;
    }

    public final int getNext(int index) {
        if (this._begin > this._end) {
            return index - this._step;
        }
        return index + this._step;
    }

    public static LoopRange parse(String value) throws LoopRangeSyntaxException {
        Matcher m;
        if (value == null || value.trim().length() == 0) {
            return new LoopRange(0, 0);
        }
        if (PTN_N.matcher(value).matches()) {
            return new LoopRange(0, Integer.parseInt(value));
        }
        if (PTN_S2E1.matcher(value).matches()) {
            Matcher m2 = PTN_S2E1.matcher(value);
            if (m2.find()) {
                return new LoopRange(Integer.parseInt(m2.group(1)), Integer.parseInt(m2.group(2)) + 1);
            }
        } else if (PTN_S2E2.matcher(value).matches()) {
            Matcher m3 = PTN_S2E2.matcher(value);
            if (m3.find()) {
                return new LoopRange(Integer.parseInt(m3.group(1)), Integer.parseInt(m3.group(2)));
            }
        } else if (PTN_A_LEN.matcher(value).matches() && (m = PTN_A_LEN.matcher(value)).find()) {
            int begin = Integer.parseInt(m.group(1));
            return new LoopRange(begin, Integer.parseInt(m.group(2)) + begin - 1);
        }
        throw new LoopRangeSyntaxException(value);
    }
}

