/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.CodeListLoader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * defineCodeList ^O̎NXB
 *
 * <p>
 * T[ubgReLXg
 *  id Ŏw肳ꂽ CodeListLoader ToA
 * ̒ɕۑĂR[hXg擾B
 * Ȃꍇ͋̃R[hXg̎擾sB
 * </p>
 *
 * R[hXg̗vf̓vpeB id A name
 * Ŋi[Ă邽߁AANZX邽߂ɂ́A^ÕvpeB
 * vfpB
 * R[hXg̓ǂݍ݂́A
 * {@link jp.terasoluna.fw.web.codelist.CodeListLoader}
 * C^tF[X̎NXQƂ̂ƁB
 *
 *
 * <strong>^OT|[g鑮</strong><br>
 * <p> defineCodeList ^Oł́Aȉ̑T|[gB</p>
 * <div align="center">
 * <table width="90%" border="1" bgcolor="#FFFFFF">
 *  <tr>
 *   <td> <b></b> </td>
 *   <td> <b>ftHgl</b> </td>
 *   <td> <b>K{</b> </td>
 *   <td> <b>s</b> </td>
 *   <td> <b>Tv</b> </td>
 *  </tr>
 *  <tr>
 *   <td> <code>id</code> </td>
 *   <td> <code>-</code> </td>
 *   <td> <code>true</code> </td>
 *   <td> <code>true</code> </td>
 *   <td align="left">
 *    ̑CodeListLoaderB܂
 *    {@link jp.terasoluna.fw.web.codelist.CodeListLoader}
 *    C^tF[Xbean̖Ow肷B
 *    ̃^O錾ȍ~A&lt;logic:iterator&gt;^OA
 *    &lt;html:options&gt;^OȂǂŃR[hXgQƂłB
 *  </tr>
 * </table>
 * </div>
 * </p>
 * <strong>JX^^ÕXNveBOϐ</strong><br>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 * <br>
 * <strong>gp@</strong><br>
 * <p>
 * ȉ̗́ACodeListLoader C^tF[XNX bean 
 * &quot;loader1&quot;ƌOŒ`Ďgpꍇ̐ݒłB<br>
 * `̕@
 * {@link jp.terasoluna.fw.web.codelist.DBCodeListLoader}A
 * y
 * {@link jp.terasoluna.fw.web.codelist.MappedCodeListLoader}
 * QƁB
 * </p>
 *
 * <strong>JSP ł̋LqB</strong><br>
 *
 * <code><pre>
 *  &lt;t:defineCodeList id=<b>"loader1"</b> /&gt;
 *  c
 *  &lt;html:select property="selectOptions"&gt;
 *    &lt;html:options collection=<b>"loader1"</b>
 *                  labelProperty=<b>"name"</b>
 *                  property=<b>"id"</b>/&gt;
 *  &lt;/html:select&gt;
 *  c
 * </pre></code>
 * R[hXg̃TCY擾ɊւẮA{@link WriteCodeCountTag} Q
 * </p>
 *
 * @see jp.terasoluna.fw.web.codelist.CodeListLoader
 * @see jp.terasoluna.fw.web.codelist.DBCodeListLoader
 * @see jp.terasoluna.fw.web.codelist.MappedCodeListLoader
 * @see jp.terasoluna.fw.web.taglib.WriteCodeCountTag
 *
 */
public class DefineCodeListTag extends TagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 7550280327858449058L;

    /**
     * ONXB
     */
     private static Log log =
         LogFactory.getLog(DefineCodeListTag.class);

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * <p>
     * T[ubgReLXgAApplicationContext擾A
     * &quot;page&quot; Ŏw肳ꂽ id
     *  CodeListLoader 擾A̒
     * R[hXg pageContext ɓo^B
     *
     * R[hXgłȂꍇAArrayList
     *  pageContext ɓo^B
     * ȂAo^̃XR[v &quot;page&quot; ƂB
     * </p>
     *
     * @return wB EVAL_BODY_INCLUDE
     * @throws JspException JSP O
     */
    @Override
    public int doStartTag() throws JspException {
        if (log.isDebugEnabled()) {
            log.debug("doStartTag() called.");
        }

        if ("".equals(id)) {
            // id݂Ȃꍇ
            log.error("id is required.");
            throw new JspTagException("id is required.");
        }
        // T[ubgReLXgAApplicationContext擾B
        ServletContext sc = pageContext.getServletContext();
        ApplicationContext context =
            WebApplicationContextUtils.getRequiredWebApplicationContext(sc);

        CodeListLoader loader = null;

        try {
            loader = (CodeListLoader) context.getBean(id);
        } catch (ClassCastException e) {
            //擾BeanCodeListLoaderł͂ȂOX[
            String errorMessage = "bean id:" + id
                + " is not instance of CodeListLoader.";
            log.error(errorMessage);
            throw new JspTagException(errorMessage, e);
        }

        CodeBean[] codeBeanArray = loader.getCodeBeans();
        if (codeBeanArray == null) {
            // codeBeanListnull̏ꍇArrayListݒ肷B
            if (log.isWarnEnabled()) {
                log.warn("Codebean is null. CodeListLoader(bean id:"
                        + id + ")");
            }
            pageContext.setAttribute(id ,
                    new ArrayList() , PageContext.PAGE_SCOPE);
        } else {
            // R[hXgo^B
            pageContext.setAttribute(
                    id , codeBeanArray , PageContext.PAGE_SCOPE);
        }

        return EVAL_BODY_INCLUDE;
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return wB EVAL_PAGE
     * @throws JspException JSP O
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

    /**
     * ^Onh̏B
     */
    @Override
    public void release() {
        super.release();
    }

}
