/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.tutorial.web.usermanager.form;

import java.text.SimpleDateFormat;
import jp.terasoluna.fw.util.DateUtil;
import jp.terasoluna.fw.web.struts.form.MultiFieldValidator;

/**
 * ͂ꂽNƁAN̑֓̓`FbNsB
 * 
 */
public class AgeValidator implements MultiFieldValidator {

    /**
     * ͂ꂽNƁAN̑֓̓`FbNsB
     * 
     * @param birth N
     * @param fields ֘A̓tB[hl
     * @return `FbN
     */
    public boolean validate(String birth, String[] fields) {
        String age = fields[0];

        if (birth == null || "".equals(birth)) {
            return true;
        }

        return checkBirthAndAge(birth, Integer.parseInt(age));
    }

    /**
     * ͂ꂽNvZNƓ͂ꂽNrB
     * ̏ꍇtrueԋpAقȂĂꍇ́AfalseԋpB
     * 
     * @param birth ͂ꂽa
     * @param age ͂ꂽN
     * @return r
     */
    private boolean checkBirthAndAge(String birth, int age) {

        //ݓt̎擾
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        String temp = format.format(DateUtil.getSystemTime());

        //NzɕϊB
        String[] old = birth.split("/");
        String[] now = temp.split("/");

        //PɌ݂̔NA͂ꂽNB
        int minus = Integer.parseInt(now[0]) - Integer.parseInt(old[0]);

        //͂ꂽ݂̌ȉ̏ꍇA
        //͂ꂽ݂̓ꍇ́A}CiXPB
        if ((Integer.parseInt(now[1]) < Integer.parseInt(old[1]))
         || (Integer.parseInt(now[1]) == Integer.parseInt(old[1])
         && Integer.parseInt(now[2]) < Integer.parseInt(old[2]))) {
            minus--;
        }

        //͂ꂽNƔrB
        if (age == minus) {
            return true;
        }
        return false;
    }
}
