/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.blogicio.web;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * NGXg̃p[^f[^XR[vɊi[tB^[NXB<br>
 * p[^ɂăp[^f[^XR[vɊi[B<br><br>
 * ep[^ɑ΂i[͈ȉłB<br>
 * <table border="1" frame='box'>
 *   <tr>
 *     <td>p[^</td>
 *     <td>i[XR[v</td>
 *   </tr>
 *   <tr>
 *     <td>requestData</td>
 *     <td>requestXR[v</td>
 *   </tr>
 *   <tr>
 *     <td>sessionData</td>
 *     <td>sessionXR[v</td>
 *   </tr>
 *   <tr>
 *     <td>applicationData</td>
 *     <td>applicationXR[v</td>
 *   </tr>
 * </table>
 * <br>
 * ȊÕp[^͖B
 * 
 */
public class BlogicioFilter implements Filter {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(BlogicioFilter.class);

    /**
     * B
     * 
     * @param filterConfig tB^[ݒ
     * 
     * @exception ServletException O
     */
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /**
     * tB^[B
     * 
     * <p>
     * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
     * </p>
     * 
     * @param request
     *            NGXg
     * @param response
     *            X|X
     * @param chain
     *            tB^[`F[
     * 
     * @exception IOException
     *                O
     * @exception ServletException
     *                O
     */
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {
        
        String requestData = request.getParameter("requestData");
        String sessionData = request.getParameter("sessionData");
        String applicationData = request.getParameter("applicationData");
        
        if (requestData instanceof String) {
            request.setAttribute("requestData", requestData);
            
            // Log
            if (log.isDebugEnabled()) {
                log.debug("set requestData(" + requestData + ") to request.");
            }
        }
        
        if (sessionData instanceof String) {
            HttpSession session = ((HttpServletRequest) request).getSession();
            session.setAttribute("sessionData", sessionData);
            // Log
            if (log.isDebugEnabled()) {
                log.debug("set sessionData(" + sessionData + ") to session.");
            }
        }
        
        if (applicationData instanceof String) {
            HttpSession session = ((HttpServletRequest) request).getSession();
            ServletContext context = session.getServletContext();
            context.setAttribute("applicationData", applicationData);
            // Log
            if (log.isDebugEnabled()) {
                log.debug("set applicationData(" + applicationData + ") to application.");
            }
        } 
    
        chain.doFilter(request, response);
    }

    /**
     * IB
     */
    public void destroy() {
    }
}