/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.download.service;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.thin.functionsample.download.bean.FileDownLoadMenuBean;
import jp.terasoluna.fw.dao.QueryDAO;

/**
 * ꗗ擾rWlXWbNB
 * 
 * f[^x[Xʂɕ\擾B ܂Aꗗ̑S擾B
 * 
 */
public class FileDownLoadMenuServiceImpl implements FileDownLoadMenuService {

    /**
     * DAONXB SpringɂCX^Xݒ肳B
     */
    protected QueryDAO dao = null;

    /**
     * QueryDAOԋpB
     * 
     * @return ێQueryDAO
     */
    public QueryDAO getDao() {
        return dao;
    }

    /**
     * QueryDAOݒ肷B
     * 
     * @param dao
     *            QueryDAO
     */
    public void setDao(QueryDAO dao) {
        this.dao = dao;
    }

    /**
     * f[^x[Xꗗ擾B ܂Aꗗ̑S擾ԋpB
     * 
     * @param arg0
     *            IuWFNg
     * @return ꗗ
     */
    public Map<String, Object> getFileList(Object arg0) {

        FileDownLoadMenuBean[] beans = dao.executeForObjectArray(
                "upload.selectListDownload", null, FileDownLoadMenuBean.class);

        Map<String, Object> retMap = new HashMap<String, Object>();
        // ꗗ̑S擾
        retMap.put("totalCount", getFileCount());
        // ꗗ擾
        retMap.put("fileBeans", beans);

        return retMap;

    }

    /**
     * ꗗ̑S擾ĕԋpB
     * 
     * @return 擾
     */
    private Integer getFileCount() {

        Integer count = (Integer) dao.executeForObject("upload.selectFileCount", null,
                Integer.class);

        return count;
    }

}