/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.jndi.web.action;

import java.util.Map;

import jp.terasoluna.thin.functionsample.jndi.bean.ResultJndiRebindParam;
import jp.terasoluna.thin.functionsample.jndi.service.ResultJndiRebindService;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;

/**
 * IJNDI\[XύXANV
 *
 */
public class ResultJndiRebindAction 
                    extends AbstractBLogicAction<ResultJndiRebindParam> {
    /**
     * JNDI\[XrebindT[rX
     */
    protected ResultJndiRebindService resultJndiRebindService = null;
    /**
     * IJNDI\[XύX
     *
     * @param param ύXJNDI\[Xl
     * @return JNDIꗗXg
     * @throws Exception
     */
    @Override
    public BLogicResult doExecuteBLogic(ResultJndiRebindParam param) 
                                                    throws Exception {
    	BLogicResult result = new BLogicResult();
        Map<String, Object> retMap = 
                resultJndiRebindService.jndiRebind(param.getValueName(), 
                                                   param.getValueData());
        
        result.setResultObject(retMap);
        result.setResultString("success");
        
        return result;
    }
    /**
     * resultJndiRebindService擾B
     * @return resultJndiRebindService
     */
    public ResultJndiRebindService getResultJndiRebindService() {
        return resultJndiRebindService;
    }
    /**
     * resultJndiRebindServiceݒ肷B
     * @param resultJndiRebindService resultJndiRebindServiceB
     */
    public void setResultJndiRebindService(
            ResultJndiRebindService resultJndiRebindService) {
        this.resultJndiRebindService = resultJndiRebindService;
    }
}