/*
 * Copyright (c) 2008 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.config.ExceptionConfig;

/**
 * {@link jp.terasoluna.fw.web.struts.action.DefaultExceptionHandler} NX̃ubN{bNXeXg.
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * w肵OxŃOo͂OnhB<br>
 * ÕOo͂ G[ʂւ̑JڂsB<br>
 * ANVsɃVXeOƂ́AG[Oo͂ŁAYANV}bsOɒ`ĂVXeG[ʂɑJڂB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.action.DefaultExceptionHandler
 */
public class DefaultExceptionHandlerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VN.
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DefaultExceptionHandlerTest.class);
    }

    /**
     * s.
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * Is.
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^.
     *
     * @param name ̃eXgP[X̖OB
     */
    public DefaultExceptionHandlerTest(String name) {
        super(name);
    }

    /**
     * testExecute01()
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:ExceptionConfig<br>
     *                  path="/errorPath.do"<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF(߂l) ActionForward:path="/errorPath.do"<br>
     *                                module=null<br>
     *         (ԕω) O:yERROROz"OnhOm܂"<br>
     *                         yDEBUGOzio͂Ȃj<br>
     *
     * <br>
     * ExceptionConfigݒ肵ꍇAftHgERRORx
     * Oo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute01() throws Exception {
        // O

        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        // O
        Exception e = new Exception();

        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");

        ActionMapping mapping = new ActionMapping();
        DynaActionForm formInstance = new DynaActionForm();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        ActionForward forward = handler.execute(e, eConfig, mapping, formInstance,
                request, response);

        // 
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        assertNull(forward.getModule());
        // O̊mF
        assertTrue(LogUTUtil.checkError("OnhOm܂", e));
        assertFalse(LogUTUtil.checkDebug("OnhOm܂", e));

    }

    /**
     * testExecute02().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:ExceptionConfigEx<br>
     *                  path="/errorPath.do"<br>
     *                  module="module"<br>
     *                  logLevel=DefaultExceptionHandler.LOG_LEVEL_TRACE<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF(߂l) ActionForward:path="/errorPath.do"<br>
     *                                module="module"<br>
     *         (ԕω) O:yTRACEOz"OnhOm܂"<br>
     *                         yDEBUGOzio͂Ȃj<br>
     *
     * <br>
     * ExceptionConfigExlogLevelTRACEݒ肵AJڐ惂W[ݒ肵ꍇA
     * TRACExŃOo͂AANVtH[hɑJڐ惂W[ݒ
     * 邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute02() throws Exception {
        // O

        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        // O
        Exception e = new Exception();

        // Oݒ
        ExceptionConfigEx eConfig = new ExceptionConfigEx();
        eConfig.setPath("/errorPath.do");
        eConfig.setModule("module");
        eConfig.setLogLevel(DefaultExceptionHandler.LOG_LEVEL_TRACE);

        ActionMapping mapping = new ActionMapping();
        DynaActionForm formInstance = new DynaActionForm();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        ActionForward forward = handler.execute(e, eConfig, mapping, formInstance,
                request, response);

        // 

        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        assertEquals("module", forward.getModule());
        // O̊mF
        assertTrue(LogUTUtil.checkTrace("OnhOm܂", e));
        assertFalse(LogUTUtil.checkDebug("OnhOm܂", e));

    }

    /**
     * testExecute03().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:ExceptionConfigEx<br>
     *                  path="/errorPath.do"<br>
     *                  logLevel=DefaultExceptionHandler.LOG_LEVEL_DEBUG<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF(߂l) ActionForward:path="/errorPath.do"<br>
     *                                module=null<br>
     *         (ԕω) O:yDEBUGOz"OnhOm܂"<br>
     *
     * <br>
     * ExceptionConfigExlogLevelDEBUGݒ肵ꍇA
     * DEBUGxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute03() throws Exception {
        // O

        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        // O
        Exception e = new Exception();

        // Oݒ
        ExceptionConfigEx eConfig = new ExceptionConfigEx();
        eConfig.setPath("/errorPath.do");
        eConfig.setLogLevel(DefaultExceptionHandler.LOG_LEVEL_DEBUG);

        ActionMapping mapping = new ActionMapping();
        DynaActionForm formInstance = new DynaActionForm();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        ActionForward forward = handler.execute(e, eConfig, mapping, formInstance,
                request, response);

        // 

        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        assertNull(forward.getModule());
        // O̊mF
        assertTrue(LogUTUtil.checkDebug("OnhOm܂", e));

    }

    /**
     * testExecute04().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:ExceptionConfigEx<br>
     *                  path="/errorPath.do"<br>
     *                  logLevel=DefaultExceptionHandler.LOG_LEVEL_INFO<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF(߂l) ActionForward:path="/errorPath.do"<br>
     *                                module=null<br>
     *         (ԕω) O:yINFOOz"OnhOm܂"<br>
     *                         yDEBUGOzio͂Ȃj<br>
     * <br>
     * ExceptionConfigExlogLevelINFOݒ肵ꍇA
     * INFOxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute04() throws Exception {
        // O

        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        // O
        Exception e = new Exception();

        // Oݒ
        ExceptionConfigEx eConfig = new ExceptionConfigEx();
        eConfig.setPath("/errorPath.do");
        eConfig.setLogLevel(DefaultExceptionHandler.LOG_LEVEL_INFO);

        ActionMapping mapping = new ActionMapping();
        DynaActionForm formInstance = new DynaActionForm();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        ActionForward forward = handler.execute(e, eConfig, mapping, formInstance,
                request, response);

        // 

        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        assertNull(forward.getModule());
        // O̊mF
        assertTrue(LogUTUtil.checkInfo("OnhOm܂", e));
        assertFalse(LogUTUtil.checkDebug("OnhOm܂", e));

    }

    /**
     * testExecute05().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:ExceptionConfigEx<br>
     *                  path="/errorPath.do"<br>
     *                  logLevel=DefaultExceptionHandler.LOG_LEVEL_WARN<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF(߂l) ActionForward:path="/errorPath.do"<br>
     *                                module=null<br>
     *         (ԕω) O:yWARNOz"OnhOm܂"<br>
     *                         yDEBUGOzio͂Ȃj<br>
     * <br>
     * ExceptionConfigExlogLevelWARNݒ肵ꍇA
     * WARNxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute05() throws Exception {
        // O

        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        // O
        Exception e = new Exception();

        // Oݒ
        ExceptionConfigEx eConfig = new ExceptionConfigEx();
        eConfig.setPath("/errorPath.do");
        eConfig.setLogLevel(DefaultExceptionHandler.LOG_LEVEL_WARN);

        ActionMapping mapping = new ActionMapping();
        DynaActionForm formInstance = new DynaActionForm();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        ActionForward forward = handler.execute(e, eConfig, mapping, formInstance,
                request, response);

        // 

        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        assertNull(forward.getModule());
        // O̊mF
        assertTrue(LogUTUtil.checkWarn("OnhOm܂", e));
        assertFalse(LogUTUtil.checkDebug("OnhOm܂", e));

    }

    /**
     * testExecute06().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:ExceptionConfigEx<br>
     *                  path="/errorPath.do"<br>
     *                  logLevel=DefaultExceptionHandler.LOG_LEVEL_ERROR<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF(߂l) ActionForward:path="/errorPath.do"<br>
     *                                module=null<br>
     *         (ԕω) O:yERROROz"OnhOm܂"<br>
     *                         yDEBUGOzio͂Ȃj<br>
     * <br>
     * ExceptionConfigExlogLevelERRORݒ肵ꍇA
     * ERRORxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute06() throws Exception {
        // O

        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        // O
        Exception e = new Exception();

        // Oݒ
        ExceptionConfigEx eConfig = new ExceptionConfigEx();
        eConfig.setPath("/errorPath.do");
        eConfig.setLogLevel(DefaultExceptionHandler.LOG_LEVEL_ERROR);

        ActionMapping mapping = new ActionMapping();
        DynaActionForm formInstance = new DynaActionForm();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        ActionForward forward = handler.execute(e, eConfig, mapping, formInstance,
                request, response);

        // 

        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        assertNull(forward.getModule());
        // O̊mF
        assertTrue(LogUTUtil.checkError("OnhOm܂", e));
        assertFalse(LogUTUtil.checkDebug("OnhOm܂", e));

    }

    /**
     * testExecute07().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:ExceptionConfigEx<br>
     *                  path="/errorPath.do"<br>
     *                  logLevel=DefaultExceptionHandler.LOG_LEVEL_FATAL<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF(߂l) ActionForward:path="/errorPath.do"<br>
     *                                module=null<br>
     *         (ԕω) O:yFATALOz"OnhOm܂"<br>
     *                         yDEBUGOzio͂Ȃj<br>
     * <br>
     * ExceptionConfigExlogLevelFATALݒ肵ꍇA
     * FATALxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute07() throws Exception {
        // O

        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        // O
        Exception e = new Exception();

        // Oݒ
        ExceptionConfigEx eConfig = new ExceptionConfigEx();
        eConfig.setPath("/errorPath.do");
        eConfig.setLogLevel(DefaultExceptionHandler.LOG_LEVEL_FATAL);

        ActionMapping mapping = new ActionMapping();
        DynaActionForm formInstance = new DynaActionForm();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        ActionForward forward = handler.execute(e, eConfig, mapping, formInstance,
                request, response);

        // 

        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        assertNull(forward.getModule());
        // O̊mF
        assertTrue(LogUTUtil.checkFatal("OnhOm܂", e));
        assertFalse(LogUTUtil.checkDebug("OnhOm܂", e));

    }

    /**
     * testLogExceptionException01().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yDEBUGOzio͂Ȃj<br>
     *
     * <br>
     * X[p[NXExceptionHandler#logException(Exception e)̏
     * I[o[ChAfobOOo͂ȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionException01() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        Exception e = null;
        
        // eXg{
        handler.logException(e);
    
        // 
    
        // O̊mF
        assertFalse(LogUTUtil.checkDebug("OnhOm܂", e));
    
    }

    /**
     * testLogExceptionException02().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yDEBUGOzio͂Ȃj<br>
     *
     * <br>
     * X[p[NXExceptionHandler#logException(Exception e)̏
     * I[o[ChAfobOOo͂ȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionException02() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        Exception e = new Exception();
        
        // eXg{
        handler.logException(e);
    
        // 
    
        // O̊mF
        assertFalse(LogUTUtil.checkDebug("OnhOm܂", e));
    
    }

    /**
     * testLogExceptionExceptionString01().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROz"OnhOm܂"<br>
     *
     * <br>
     * enulllogLevelnull̏ꍇAftHgERRORx
     * Oo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionString01() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        Exception e = null;
        String logLevel = null;
        
        // eXg{
        handler.logException(e, logLevel);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError("OnhOm܂"));
    
    }

    /**
     * testLogExceptionExceptionString02().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_TRACE<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yTRACEOz"OnhOm܂"<br>
     *
     * <br>
     * enulllogLevelݒ肳ĂꍇAݒ肳ꂽOx
     * Oo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionString02() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        Exception e = null;
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_TRACE;
        
        // eXg{
        handler.logException(e, logLevel);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkTrace("OnhOm܂"));
    
    }

    /**
     * testLogExceptionExceptionString03().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROz"OnhOm܂"<br>
     *                         o͂OFException<br>
     * <br>
     * enullłȂlogLevelnull̏ꍇAftHgERRORx
     * Oo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionString03() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        Exception e = new Exception();
        String logLevel = null;
        
        // eXg{
        handler.logException(e, logLevel);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError("OnhOm܂", e));
    
    }

    /**
     * testLogExceptionExceptionString04().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_TRACE<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yTRACEOz"OnhOm܂"<br>
     *                         o͂OFException<br>
     * <br>
     * enullłȂlogLevelݒ肳ĂꍇAݒ肳ꂽOx
     * Oo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionString04() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        Exception e = new Exception();
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_TRACE;
        
        // eXg{
        handler.logException(e, logLevel);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkTrace("OnhOm܂", e));
    
    }

    /**
     * testLogExceptionExceptionStringString01().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:null<br>
     *         () message:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROznull<br>
     *
     * <br>
     * enulllogLevelƃbZ[Wݒ肳ĂȂꍇA
     * ftHgERRORxnull̃Oo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString01() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = null;
        String logLevel = null;
        String message = null;
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError(null));
    
    }

    /**
     * testLogExceptionExceptionStringString02().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:null<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROz"hoge"<br>
     *
     * <br>
     * enulllogLevelݒ肳Ă炸bZ[Wݒ肳ĂꍇA
     * ftHgERRORxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString02() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = null;
        String logLevel = null;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError("hoge"));
    
    }

    /**
     * testLogExceptionExceptionStringString03().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_TRACE<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yTRACEOz"hoge"<br>
     *
     * <br>
     * enulllogLevelTRACEŃbZ[Wݒ肳ĂꍇA
     * TRACExŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString03() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = null;
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_TRACE;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkTrace("hoge"));
    
    }

    /**
     * testLogExceptionExceptionStringString04().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_DEBUG<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yDEBUGOz"hoge"<br>
     *
     * <br>
     * enulllogLevelDEBUGŃbZ[Wݒ肳ĂꍇA
     * DEBUGxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString04() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = null;
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_DEBUG;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkDebug("hoge"));
    
    }

    /**
     * testLogExceptionExceptionStringString05().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_INFO<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yINFOOz"hoge"<br>
     *
     * <br>
     * enulllogLevelINFOŃbZ[Wݒ肳ĂꍇA
     * INFOxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString05() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = null;
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_INFO;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkInfo("hoge"));
    
    }

    /**
     * testLogExceptionExceptionStringString06().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_WARN<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yWARNOz"hoge"<br>
     *
     * <br>
     * enulllogLevelWARNŃbZ[Wݒ肳ĂꍇA
     * WARNxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString06() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = null;
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_WARN;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkWarn("hoge"));
    
    }

    /**
     * testLogExceptionExceptionStringString07().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_ERROR<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROz"hoge"<br>
     *
     * <br>
     * enulllogLevelERRORŃbZ[Wݒ肳ĂꍇA
     * ERRORxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString07() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = null;
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_ERROR;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError("hoge"));
    
    }

    /**
     * testLogExceptionExceptionStringString08().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:null<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_FATAL<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yFATALOz"hoge"<br>
     *
     * <br>
     * enulllogLevelFATALŃbZ[Wݒ肳ĂꍇA
     * FATALxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString08() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = null;
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_FATAL;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkFatal("hoge"));
    
    }

    /**
     * testLogExceptionExceptionStringString09().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:null<br>
     *         () message:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROznull<br>
     *                         o͂OFException<br>
     *
     * <br>
     * eɗOݒ肳ĂAlogLevelƃbZ[Wݒ肳ĂȂꍇA
     * ftHgERRORxnull̃OƗOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString09() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = new Exception();
        String logLevel = null;
        String message = null;
    
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError(null, e));
    
    }

    /**
     * testLogExceptionExceptionStringString10().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:null<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROz"hoge"<br>
     *                         o͂OFException<br>
     *
     * <br>
     * eɗOݒ肳ĂAlogLevelݒ肳Ă炸bZ[Wݒ肳ĂꍇA
     * ftHgERRORxŃOƗOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString10() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = new Exception();
        String logLevel = null;
        String message = "hoge";
    
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError("hoge", e));
    
    }

    /**
     * testLogExceptionExceptionStringString11().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_TRACE<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yTRACEOz"hoge"<br>
     *                         o͂OFException<br>
     *
     * <br>
     * eɗOݒ肳ĂAlogLevelTRACEŃbZ[Wݒ肳ĂꍇA
     * TRACExŃOƗOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString11() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = new Exception();
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_TRACE;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkTrace("hoge", e));
    
    }

    /**
     * testLogExceptionExceptionStringString12().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_DEBUG<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yDEBUGOz"hoge"<br>
     *                         o͂OFException<br>
     *
     * <br>
     * eɗOݒ肳ĂAlogLevelDEBUGŃbZ[Wݒ肳ĂꍇA
     * DEBUGxŃOƗOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString12() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = new Exception();
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_DEBUG;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkDebug("hoge", e));
    
    }

    /**
     * testLogExceptionExceptionStringString13().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_INFO<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yINFOOz"hoge"<br>
     *                         o͂OFException<br>
     *
     * <br>
     * eɗOݒ肳ĂAlogLevelINFOŃbZ[Wݒ肳ĂꍇA
     * INFOxŃOƗOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString13() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = new Exception();
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_INFO;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkInfo("hoge", e));
    
    }

    /**
     * testLogExceptionExceptionStringString14().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_WARN<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yWARNOz"hoge"<br>
     *                         o͂OFException<br>
     *
     * <br>
     * eɗOݒ肳ĂAlogLevelWARNŃbZ[Wݒ肳ĂꍇA
     * WARNxŃOƗOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString14() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = new Exception();
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_WARN;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkWarn("hoge", e));
    
    }

    /**
     * testLogExceptionExceptionStringString15().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_ERROR<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROz"hoge"<br>
     *                         o͂OFException<br>
     *
     * <br>
     * eɗOݒ肳ĂAlogLevelERRORŃbZ[Wݒ肳ĂꍇA
     * ERRORxŃOƗOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString15() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = new Exception();
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_ERROR;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError("hoge", e));
    
    }

    /**
     * testLogExceptionExceptionStringString16().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() e:Exception<br>
     *         () logLevel:DefaultExceptionHandler.LOG_LEVEL_FATAL<br>
     *         () message:"hoge"<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yFATALOz"hoge"<br>
     *                         o͂OFException<br>
     *
     * <br>
     * eɗOݒ肳ĂAlogLevelFATALŃbZ[Wݒ肳ĂꍇA
     * FATALxŃOƗOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionExceptionStringString16() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        Exception e = new Exception();
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_FATAL;
        String message = "hoge";
        
        // eXg{
        handler.logException(e, logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkFatal("hoge", e));
    
    }

    /**
     * testLogExceptionStringString01().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() logLevel:null<br>
     *         () message:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROznull<br>
     *
     * <br>
     * logLevelnullmessagenull̏ꍇA
     * ftHgERRORxnull̃Oo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionStringString01() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        String logLevel = null;
        String message = null;
        
        // eXg{
        handler.logException(logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError(null));
    
    }

    /**
     * testLogExceptionStringString02().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() logLevel:null<br>
     *         () message:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yERROROz"hoge"<br>
     *
     * <br>
     * logLevelnullmessagenullłȂꍇA
     * ftHgERRORxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionStringString02() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        String logLevel = null;
        String message = "hoge";
        
        // eXg{
        handler.logException(logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkError("hoge"));
    
    }

    /**
     * testLogExceptionStringString03().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() logLevel:DefaultExceptionHandler.LOG_LEVEL_TRACE<br>
     *         () message:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yTRACEOznull<br>
     *
     * <br>
     * logLevelݒ肳Ămessagenull̏ꍇA
     * ݒ肳ꂽOxnull̃Oo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionStringString03() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_TRACE;
        String message = null;
        
        // eXg{
        handler.logException(logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkTrace(null));
    
    }

    /**
     * testLogExceptionStringString04().
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() logLevel:DefaultExceptionHandler.LOG_LEVEL_TRACE<br>
     *         () message:null<br>
     *         (O) messages:-<br>
     * <br>
     * ҒlF
     *         (ԕω) O:yTRACEOz"hoge"<br>
     *
     * <br>
     * logLevelݒ肳ĂmessagenullłȂꍇA
     * ݒ肳ꂽOxŃOo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLogExceptionStringString04() throws Exception {
        // O
    
        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();
    
        String logLevel = DefaultExceptionHandler.LOG_LEVEL_TRACE;
        String message = "hoge";
        
        // eXg{
        handler.logException(logLevel, message);
    
        // 
    
        // O̊mF
        assertTrue(LogUTUtil.checkTrace("hoge"));
    
    }

    /**
     * testGetLogger01()
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF(O) logger:-<br>
     * <br>
     * ҒlF(߂l) LogFactory.getLog(DefaultExceptionHandler.class)Ɠ̃CX^X<br>
     * <br>
     * n1݂̂̃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetLogger01() throws Exception {
        // O

        // ėpOnh
        DefaultExceptionHandler handler = new DefaultExceptionHandler();

        // eXg{
        Log logger = handler.getLogger();

        // 
        assertSame(LogFactory.getLog(DefaultExceptionHandler.class), logger);
    }

}
