/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.servlet.ServletException;

import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.web.struts.reset.Resetter;
import jp.terasoluna.fw.web.struts.reset.ResetterImpl;
import jp.terasoluna.fw.web.struts.reset.ResetterResources;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;
import org.xml.sax.SAXException;

/**
 * gResetterPlugInNXłB ChJ[hŎw肵pXɃ}b`郊Zbg`t@Cireset.xmlj[hAT[ubgReLXgɕۑ悤ɁA
 * TERASOLUNA񋟂ResetterPlugIngĂ܂B
 * @see jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn
 */
public class ResetterPlugInEx implements PlugIn {

    /**
     * OCX^X
     */
    private static Log log = LogFactory.getLog(ResetterPlugInEx.class);

    /**
     * ftHg tH[Zbg`t@C(reset.xml) ̃pX
     */
    private static final String DIGESTER_RULES_PATH = "/WEB-INF/reset-rules.xml";

    /**
     * tH[Zbg[`t@C(reset-rules.xml) ̏ݒς݂ DigesterCX^X̎Q
     */
    private static Digester digester = null;

    /**
     * ftHgZb^NX̊SCNX
     */
    private static final String DEFAULT_RESETTER = ResetterImpl.class.getName();

    /**
     * DTĎJʎq
     */
    private String publicIdentifier = "-//NTTDATA//DTD TERASOLUNA for Spring reset 1.0//JA";

    /**
     * DTDpX
     */
    private String dtdUrl = "/jp/terasoluna/fw/web/struts/plugins/dtd/reset.dtd";

    /**
     * Zb^NX̊SCNX
     */
    private String resetter = null;

    /**
     * tH[Zbg`t@C(reset.xml) ̃pX
     */
    private String resourcesPath = null;

    /**
     * tH[Zbg[`t@C(reset-rules.xml) ̃pX
     */
    private String digesterRules = null;

    /**
     * I
     */
    public void destroy() {
        // Ȃ
    }

    /**
     * 
     * @param servlet  PlugIn N ActionServletB
     * @param config  PlugIn ̑ ModuleConfigB
     * @exception ServletException ɔObvOB
     */
    public void init(ActionServlet servlet, ModuleConfig config)
                                                                throws ServletException {

        if (log.isDebugEnabled()) {
            log.debug("init() called.");
        }

        // Resetteȑ
        initResetter(servlet, config);

        // ResetterResources̏
        initResources(servlet, config);
    }

    /**
     * ZbgNX̏B Strutsݒt@C(struts-config.xml) ɐݒ肵ZbgNX擾܂B ݒ̏ꍇ̓ftHgZbgNX擾܂B
     * @param servlet  PlugIn N ActionServletB
     * @param config  PlugIn ̑ ModuleConfigB
     * @exception ServletException ZbgNX̏ɔO
     */
    protected void initResetter(ActionServlet servlet, ModuleConfig config)
                                                                           throws ServletException {

        // Resetter̃CX^Xi[ϐ
        Resetter resetterObj = null;

        try {
            if (this.resetter == null || "".equals(this.resetter)) {
                resetterObj = (Resetter) ClassUtil.create(DEFAULT_RESETTER);
            } else {
                resetterObj = (Resetter) ClassUtil.create(this.resetter);
            }
        } catch (ClassLoadException e) {
            log.error("", e);
            throw new ServletException(e);
        }

        // ResetterT[ubgReLXgɒǉ
        servlet.getServletContext().setAttribute(
                Resetter.RESETTER_KEY + config.getPrefix(), resetterObj);
    }

    /**
     * ZbgB tH[Zbg`t@C(reset.xml)A tH[Zbg[`t@C(reset-rules.xml)𗘗pāA ݒ
     * {@link jp.terasoluna.fw.web.struts.reset.ResetterResources} ɓǂݍށB
     * ResourcePatternResolver𗘗pAChJ[hŎw肵pXɃ}b`郊Zbg`t@Cireset.xmlj[h܂B
     * @param servlet ̃vOCNT[ubgB
     * @param config W[RtBO
     * @exception ServletException \[Xt@CȂ O
     */
    protected void initResources(ActionServlet servlet, ModuleConfig config)
                                                                            throws ServletException {

        if (this.resourcesPath == null || "".equals(this.resourcesPath)) {
            log.error("resources file location is not specified");
            throw new ServletException(
                    "resources file location is not specified");
        }
        StringTokenizer st = new StringTokenizer(resourcesPath, ",");
        List<String> pathList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            path = path.trim();
            if (log.isDebugEnabled()) {
                log.debug("reset file=" + path);
            }
            pathList.add(path);
        }
        if (digester == null) {
            if (digesterRules == null) {
                // [t@Cݒ̂ƂAftHg̃[t@C
                // ݒ肵܂B
                digesterRules = DIGESTER_RULES_PATH;
            }
            // Digester̐
            try {
                digester = DigesterLoader.createDigester(servlet
                        .getServletContext().getResource(digesterRules));
                digester.setValidating(true);
            } catch (MalformedURLException e) {
                log.error("", e);
                throw new ServletException(e);
            } catch (XmlLoadException e) {
                log.error("", e);
                throw new ServletException(e);
            }
        }
        ResetterResources resetterResources = new ResetterResources();
        try {
            for (int i = 0; i < pathList.size(); i++) {
                ResourcePatternResolver resourcePatternResolver = new ServletContextResourcePatternResolver(
                        servlet.getServletContext());
                Resource[] resources = resourcePatternResolver
                        .getResources(pathList.get(i));
                for (Resource resource : resources) {
                    if (log.isInfoEnabled()) {
                        log.info("Loading reset definition file from '"
                                + resource + "'");
                    }

                    digester.push(resetterResources);
                    URL url = this.getClass().getResource(getDtdUrl());
                    if (url != null) {
                        digester
                                .register(getPublicIdentifier(), url.toString());
                    }
                    digester.parse(resource.getInputStream());
                }
            }
        } catch (IOException e) {
            log.error("", e);
            throw new ServletException(e);
        } catch (SAXException e) {
            log.error("", e);
            throw new ServletException(e);
        }
        // ResetterResourcesT[ubgReLXgɒǉ
        servlet.getServletContext().setAttribute(
                ResetterResources.RESETTER_RESOURCES_KEY + config.getPrefix(),
                resetterResources);
    }

    /**
     * Jʎqԋp܂B JʎqύXꍇ́Ã\bhI[o[Ch܂B
     * @return Jʎq
     */
    public String getPublicIdentifier() {
        return publicIdentifier;
    }

    /**
     * DTDURLԋp܂B DTDURLύXꍇ́Ã\bhI[o[Ch܂B
     * @return DTDURL
     */
    public String getDtdUrl() {
        return dtdUrl;
    }

    /**
     * Strutsݒt@C(struts-config.xml) ɐݒ肳Ă郊Zb^̊SC ݒ肵܂B
     * @param string Zb^̊SC
     */
    public void setResetter(String string) {
        resetter = string;
    }

    /**
     * tH[Zbg`t@C(reset.xml)̃pXݒ肵܂B
     * @param string tH[Zbg`t@C(reset.xml)̃pX
     */
    public void setResources(String string) {
        resourcesPath = string;
    }

    /**
     * tH[Zbg[`t@C(reset-rules.xml)ݒ肵܂B
     * @param digesterRules tH[Zbg[`t@C(reset-rules.xml) ̃pX
     */
    public void setDigesterRules(String digesterRules) {
        this.digesterRules = digesterRules;
    }

    /**
     * Jʎqݒ肵܂B
     * @param publicIdentifier Jʎq
     */
    public void setPublicIdentifier(String publicIdentifier) {
        this.publicIdentifier = publicIdentifier;
    }

    /**
     * DTDURLݒ肵܂B
     * @param dtdUrl DTDURL
     */
    public void setDtdUrl(String dtdUrl) {
        this.dtdUrl = dtdUrl;
    }
}
