/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    rtsyn_winmm.c
        Copyright (c) 2003 Keishi Suenaga <s_keishi@mutt.freemail.ne.jp>

    I referenced following sources.
        alsaseq_c.c - ALSA sequencer server interface
            Copyright (c) 2000  Takashi Iwai <tiwai@suse.de>
        readmidi.c

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include "interface.h"

#include <stdio.h>

#include <stdarg.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <math.h>
#include <signal.h>

#include "timip_server_defs.h"

#ifdef __W32__
#include <windows.h>
#include <mmsystem.h>
#endif

#include "timip_timidity.h"
#include "timip_common.h"
#include "timip_controls.h"
#include "timip_instrum.h"
#include "timip_playmidi.h"
#include "timip_readmidi.h"
#include "timip_recache.h"
#include "timip_output.h"
#include "timip_aq.h"
#include "timip_timer.h"

#include "timip_rtsyn.h"

int timip_rtsyn_portnumber=1;
unsigned int timip_portID[MAX_PORT];
char timip_rtsyn_portlist[32][80];
int timip_rtsyn_nportlist;

#define MAX_EXBUF 20
#define BUFF_SIZE 512

UINT timip_InNum;
HMIDIIN  timip_hMidiIn[MAX_PORT];
HMIDIOUT timip_hMidiOut[MAX_PORT];
MIDIHDR *timip_IMidiHdr[MAX_PORT][MAX_EXBUF];

char timip_sIMidiHdr[MAX_PORT][MAX_EXBUF][sizeof(MIDIHDR)];
char timip_sImidiHdr_data[MAX_PORT][MAX_EXBUF][BUFF_SIZE];

struct evbuf_t{
	UINT wMsg;
	DWORD	dwInstance;
	DWORD	dwParam1;
	DWORD	dwParam2;
};
#define EVBUFF_SIZE 512
struct evbuf_t timip_evbuf[EVBUFF_SIZE];
UINT  timip_evbwpoint=0;
UINT  timip_evbrpoint=0;
UINT timip_evbsysexpoint;
UINT  timip_mvbuse=0;

CRITICAL_SECTION timip_mim_section;

double timip_mim_start_time;

void CALLBACK timip_MidiInProc(HMIDIIN,UINT,DWORD,DWORD,DWORD);

void timip_rtsyn_get_port_list(){
	int i;
	MIDIINCAPS InCaps;
	timip_InNum = midiInGetNumDevs();
	for (i=1;i <=timip_InNum && i<=32;i++){
		midiInGetDevCaps(i-1,(LPMIDIINCAPSA) &InCaps,sizeof(InCaps));
		sprintf(timip_rtsyn_portlist[i-1],"%d:%s",i,(LPSTR)InCaps.szPname);
	}
	timip_rtsyn_nportlist=i-1;
}

int timip_rtsyn_synth_start(){
	int i;
	UINT port;

#ifdef __W32__
	DWORD processPriority;
	processPriority = GetPriorityClass(GetCurrentProcess());
#endif

	
	port=0;
	sleep(2);
	for(port=0;port<timip_rtsyn_portnumber;port++){
		for (i=0;i<MAX_EXBUF;i++){
			timip_IMidiHdr[port][i] = (MIDIHDR *)timip_sIMidiHdr[port][i];
			memset(timip_IMidiHdr[port][i],0,sizeof(MIDIHDR));
			timip_IMidiHdr[port][i]->lpData = timip_sImidiHdr_data[port][i];
			memset((timip_IMidiHdr[port][i]->lpData),0,BUFF_SIZE);
			timip_IMidiHdr[port][i]->dwBufferLength = BUFF_SIZE;
		}
	}
	timip_evbwpoint=0;
	timip_evbrpoint=0;
	timip_mvbuse=0;

	for(port=0;port<timip_rtsyn_portnumber;port++){
		midiInOpen(&timip_hMidiIn[port],timip_portID[port],(DWORD)timip_MidiInProc,(DWORD)port,CALLBACK_FUNCTION);
		for (i=0;i<MAX_EXBUF;i++){
			midiInUnprepareHeader(timip_hMidiIn[port],timip_IMidiHdr[port][i],sizeof(MIDIHDR));
			midiInPrepareHeader(timip_hMidiIn[port],timip_IMidiHdr[port][i],sizeof(MIDIHDR));
			midiInAddBuffer(timip_hMidiIn[port],timip_IMidiHdr[port][i],sizeof(MIDIHDR));
		}
	}

#ifdef __W32__
	// HACK:midiInOpen()ǥꥻåȤƤޤᡢ
	SetPriorityClass(GetCurrentProcess(), processPriority);
#endif
	for(port=0;port<timip_rtsyn_portnumber;port++){
		if(MMSYSERR_NOERROR !=midiInStart(timip_hMidiIn[port])){
			int i;
			for(i=0;i<port;i++){
				midiInStop(timip_hMidiIn[i]);
				midiInReset(timip_hMidiIn[i]);
				midiInClose(timip_hMidiIn[i]);
			}
			goto winmmerror;
		}
	}
	timip_mim_start_time = timip_get_current_calender_time();
	InitializeCriticalSection(&timip_mim_section);
	return ~0;

winmmerror:
	timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL, "midiInStarterror\n" );
	return 0;
}

void timip_rtsyn_synth_stop(){
	timip_rtsyn_stop_playing();
	//	timip_play_mode->close_output();
	timip_rtsyn_midiports_close();
	DeleteCriticalSection(&timip_mim_section);

	return;
}
void timip_rtsyn_midiports_close(void){
	UINT port;
	
	for(port=0;port<timip_rtsyn_portnumber;port++){
		if( MMSYSERR_NOERROR!=midiInStop(timip_hMidiIn[port]) )
			timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIDI Stop Error\n");
		if( MMSYSERR_NOERROR!=midiInReset(timip_hMidiIn[port]) ) 
			timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIDI Rest Error\n");
		if( MMSYSERR_NOERROR!=midiInClose(timip_hMidiIn[port]) ) 
			timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIDI Close Error\n");
	}
}

int timip_rtsyn_buf_check(void){
	int retval;
	EnterCriticalSection(&timip_mim_section);
	retval = (timip_evbrpoint != timip_evbwpoint) ? ~0 :  0;
	LeaveCriticalSection(&timip_mim_section);
	return retval;
}

int timip_rtsyn_play_some_data(void){
	UINT wMsg;
	DWORD	dwInstance;
	DWORD	dwParam1;
	DWORD	dwParam2;
	DWORD	timestamp;
	MidiEvent timip_ev;
	MidiEvent evm[260];
	int port;
	UINT evbpoint;
	MIDIHDR *IIMidiHdr;
	int exlen;
	char *sysexbuffer;
	int ne,i,j,chk,played;
		
	played=0;
		if( !timip_rtsyn_buf_check() ){ 
			played=~0;
			return played;
		}
		do{
			EnterCriticalSection(&timip_mim_section);
			evbpoint=timip_evbrpoint;
			if (++timip_evbrpoint >= EVBUFF_SIZE)
					timip_evbrpoint -= EVBUFF_SIZE;

			wMsg=timip_evbuf[evbpoint].wMsg;
			dwInstance=timip_evbuf[evbpoint].dwInstance;
			dwParam1=timip_evbuf[evbpoint].dwParam1;
			dwParam2=timip_evbuf[evbpoint].dwParam2;
			LeaveCriticalSection(&timip_mim_section);
		    
			port=(UINT)dwInstance;
			switch (wMsg) {
			case MIM_DATA:
				timip_rtsyn_play_one_data (port, dwParam1, timip_mim_start_time+(double)dwParam2/1000.0);
				break;
			case MIM_LONGDATA:
				IIMidiHdr = (MIDIHDR *) dwParam1;
				exlen=(int)IIMidiHdr->dwBytesRecorded;
				sysexbuffer=IIMidiHdr->lpData;
				timip_rtsyn_play_one_sysex (sysexbuffer,exlen, timip_mim_start_time+(double)dwParam2/1000.0);
				if (MMSYSERR_NOERROR != midiInUnprepareHeader(
						timip_hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"error1\n");
				if (MMSYSERR_NOERROR != midiInPrepareHeader(
						timip_hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"error5\n");
				if (MMSYSERR_NOERROR != midiInAddBuffer(
						timip_hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"error6\n");
				break;
			}
		}while(timip_rtsyn_buf_check());	
	return played;
}

void CALLBACK timip_MidiInProc(HMIDIIN hMidiInL, UINT wMsg, DWORD dwInstance,
		DWORD dwParam1, DWORD dwParam2)
{
	UINT evbpoint;
	UINT port;
	
	port=(UINT)dwInstance;
	switch (wMsg) {
	case MIM_DATA:
	case MIM_LONGDATA:
		EnterCriticalSection(&timip_mim_section);
		evbpoint = timip_evbwpoint;
		if (++timip_evbwpoint >= EVBUFF_SIZE)
			timip_evbwpoint -= EVBUFF_SIZE;
		timip_evbuf[evbpoint].wMsg = wMsg;
		timip_evbuf[evbpoint].dwInstance = dwInstance;
		timip_evbuf[evbpoint].dwParam1 = dwParam1;
		timip_evbuf[evbpoint].dwParam2 = dwParam2;
		LeaveCriticalSection(&timip_mim_section);
		break;
	case MIM_OPEN:
//		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_OPEN\n");
		break;
	case MIM_CLOSE:
//		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_CLOSE\n");
		break;
	case MIM_LONGERROR:
		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_LONGERROR\n");
		break;
	case MIM_ERROR:
		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_ERROR\n");
		break;
	case MIM_MOREDATA:
		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_MOREDATA\n");
		break;
	}
}
