/*      MikMod sound library
   (c) 1998, 1999 Miodrag Vallat and others - see file AUTHORS for
   complete list.

   This library is free software; you can redistribute it and/or modify
   it under the terms timip_of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 timip_of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy timip_of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
 */

/*==============================================================================

  $Id: unimod_priv.h,v 1.23 1999/10/25 16:31:41 miod Exp $

  MikMod sound library internal definitions

==============================================================================*/

#ifndef __TIMIP_UNIMOD_PRIV_H
#define __TIMIP_UNIMOD_PRIV_H

#ifdef WIN32
#include "timip_win32.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#if defined(HAVE_MALLOC_H) && !defined(_MSC_VER) && !defined(__BORLANDC__) && !defined(__WATCOMC__)
#include <malloc.h>
#endif
#include <stdarg.h>
#if defined(__OS2__)||defined(__EMX__)||defined(__W32__)
#ifndef strcasecmp
#define strcasecmp(s,t) stricmp(s,t)
#endif
#endif

#include "timip_unimod.h"
#include "timip_url.h"

#ifdef __W32__
#pragma warning(disable:4761)
#endif

/*========== Error handling */

#define _mm_errno timip_ML_errno

/*========== Memory allocation */

extern void *_mm_malloc (size_t);
extern void *_mm_calloc (size_t, size_t);
#define _mm_free(p) do { if (p) free(p); p = NULL; } while(0)

/*========== Portable file I/O */

#define _mm_read_SBYTE(x)	((SBYTE)url_getc(x))
#define _mm_read_UBYTE(x)	((UBYTE)url_getc(x))
#define _mm_read_SBYTES(x,y,z)	timip_url_nread(z,(void *)x,y)
#define _mm_read_UBYTES(x,y,z)	timip_url_nread(z,(void *)x,y)
#define _mm_fseek(x,y,z)	timip_url_seek(x,y,z)
#define _mm_ftell(x)		timip_url_tell(x)
#define _mm_eof(x)		url_eof(x)
#define _mm_rewind(x)		_mm_fseek(x,0,SEEK_SET)

extern int _mm_read_string (CHAR *, int, URL);

extern SWORD _mm_read_M_SWORD (URL);
extern SWORD _mm_read_I_SWORD (URL);
extern UWORD _mm_read_M_UWORD (URL);
extern UWORD _mm_read_I_UWORD (URL);

extern SLONG _mm_read_M_SLONG (URL);
extern SLONG _mm_read_I_SLONG (URL);
extern ULONG _mm_read_M_ULONG (URL);
extern ULONG _mm_read_I_ULONG (URL);

extern int _mm_read_M_SWORDS (SWORD *, int, URL);
extern int _mm_read_I_SWORDS (SWORD *, int, URL);
extern int _mm_read_M_UWORDS (UWORD *, int, URL);
extern int _mm_read_I_UWORDS (UWORD *, int, URL);

extern int _mm_read_M_SLONGS (SLONG *, int, URL);
extern int _mm_read_I_SLONGS (SLONG *, int, URL);
extern int _mm_read_M_ULONGS (ULONG *, int, URL);
extern int _mm_read_I_ULONGS (ULONG *, int, URL);


/*========== Loaders */

typedef struct MLOADER
{
  struct MLOADER *next;
  CHAR *type;
  CHAR *version;
  BOOL (*Init) (void);
  BOOL (*Test) (void);
  BOOL (*Load) (BOOL);
  void (*Cleanup) (void);
  CHAR *(*LoadTitle) (void);
}
MLOADER;

/* internal loader variables: */
LIBTIMIPDLL_API extern URL timip_modreader;
LIBTIMIPDLL_API extern UWORD timip_finetune[16];
LIBTIMIPDLL_API extern MODULE timip_of;		/* static unimod loading space */

LIBTIMIPDLL_API extern SBYTE timip_remap[64];	/* for removing empty channels */
LIBTIMIPDLL_API extern UBYTE *timip_poslookup;	/* lookup table for pattern jumps after
				 blank pattern removal */
LIBTIMIPDLL_API extern UBYTE timip_poslookupcnt;
LIBTIMIPDLL_API extern UWORD *timip_origpositions;

LIBTIMIPDLL_API extern BOOL timip_filters;		/* resonant timip_filters in use */
LIBTIMIPDLL_API extern UBYTE timip_activemacro;	/* active midi macro number for Sxx */
LIBTIMIPDLL_API extern UBYTE timip_filtermacros[16];	/* midi macros settings */
LIBTIMIPDLL_API extern FILTER timip_filtersettings[256];	/* computed filter settings */

LIBTIMIPDLL_API extern int *timip_noteindex;

/* tracker identifiers */
#define STM_NTRACKERS 3
LIBTIMIPDLL_API extern CHAR *timip_STM_Signatures[];
LIBTIMIPDLL_API extern CHAR *timip_STM_Version[];


/*========== Internal loader interface */

extern BOOL timip_ReadComment (UWORD);
extern BOOL timip_ReadLinedComment (UWORD, UWORD);
extern BOOL timip_AllocPositions (int);
extern BOOL timip_AllocPatterns (void);
extern BOOL timip_AllocTracks (void);
extern BOOL timip_AllocInstruments (void);
extern BOOL timip_AllocSamples (void);
extern CHAR *timip_DupStr (CHAR *, UWORD, BOOL);

/* loader utility functions */
extern int *timip_AllocLinear (void);
extern void timip_FreeLinear (void);
extern int timip_speed_to_finetune (ULONG, int);
extern void timip_S3MIT_ProcessCmd (UBYTE, UBYTE, BOOL);
extern void timip_S3MIT_CreateOrders (BOOL);

#ifdef __cplusplus
}
#endif

#endif

/* ex:set ts=4: */
