/*
    TiMidity++ Plain dll
    Copyright (C) 2005 Keishi Suenaga <s_keishi@mutt.freemail.ne.jp>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __LIBTIMI_P_DLL_H__
#define __LIBTIMI_P_DLL_H__

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
	
#include "timip_config.h"
#include <stdio.h>
#ifdef	TIMIP_STDC_HEADERS
#include <stdlib.h>
#include <ctype.h>
#include <stddef.h>
#endif
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#ifdef TIMIP___W32__
#include <windows.h>
#include <io.h>
#include <shlobj.h>
#endif
#ifdef	TIMIP_HAVE_UNISTD_H
#include <unistd.h>
#endif /*	TIMIP_HAVE_UNISTD_H */
#ifdef	TIMIP_HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif /* NAVE_SYS_STAT_H */
#include <fcntl.h> /* for open */

#ifdef	TIMIP_HAVE_STDBOOL_H
#include <stdbool.h>
#endif

#ifndef __bool_true_false_are_defined
# ifdef bool
#  undef bool
# endif
# ifdef ture
#  undef ture
# endif
# ifdef false
#  undef false
# endif
# define bool int
# define false ((bool)0)
# define true (!false)
# define __bool_true_false_are_defined true
#endif /* C99 _Bool hack */

#ifdef BORLANDC_EXCEPTION
#include <excpt.h>
#endif /* BORLANDC_EXCEPTION */
#include <signal.h>

#if defined(__FreeBSD__) && !defined(__alpha__)
#include <floatingpoint.h> /* For FP exceptions */
#endif
#if defined(__NetBSD__) || defined(__OpenBSD__)
#include <ieeefp.h> /* For FP exceptions */
#endif

#include "timip_interface.h"
#include "timip_timidity.h"
#include "timip_tmdy_getopt.h"
#include "timip_common.h"
#include "timip_instrum.h"
#include "timip_playmidi.h"
#include "timip_readmidi.h"
#include "timip_output.h"
#include "timip_controls.h"
#include "timip_tables.h"
#include "timip_miditrace.h"
#include "timip_reverb.h"
#ifdef SUPPORT_SOUNDSPEC
#include "timip_soundspec.h"
#endif /* SUPPORT_SOUNDSPEC */
#include "timip_resample.h"
#include "timip_recache.h"
#include "timip_arc.h"
#include "timip_strtab.h"
#include "timip_wrd.h"
#define DEFINE_GLOBALS
//#include "mid.defs"
#include "timip_aq.h"
#include "timip_mix.h"
#include "timip_unimod.h"
#include "timip_quantity.h"

#ifdef IA_W32GUI
#include "timip_w32g.h"
#include "timip_w32g_utl.h"
#endif

#include "timip_minterface.h"

#include "timip_rtsyn.h"

#ifndef __GNUC__
#define __attribute__(x) /* ignore */
#endif


#ifdef __cplusplus
}
#endif
/* __cplusplus */
	
#endif
/* __LIBTIMI_P_DLL_H__ */
